package com.elitesland.cbpl.scheduling.spi;

import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleInstanceRespVO;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
public interface ScheduleCompleteProvider {

    /**
     * 实例执行前的回调方法
     *
     * @param response 实例值
     */
    void start(ScheduleInstanceRespVO response);

    /**
     * 实例执行完后的回调方法
     *
     * @param response  实例返回值
     * @param throwable 抛出异常（正常执行时，返回null）
     */
    void whenComplete(ScheduleInstanceRespVO response, Throwable throwable);
}
