package com.elitesland.cbpl.scheduling.data.vo.param;

import com.elitesland.cbpl.tool.db.PageQueryParam;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@ApiModel("定时任务配置表")
public class ScheduleConfigPagingParamVO extends PageQueryParam {

	private static final long serialVersionUID = 2459504707510122277L;

	@ApiModelProperty(value = "任务编码/名称")
	private String taskCodeName;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "定时任务表达式")
	private String cron;

	@ApiModelProperty(value = "状态：0禁用；1启用；")
	private Integer status;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "分组标签")
	private String taskTag;
}
