package com.elitesland.cbpl.scheduling.common.controller;

import com.elitesland.cbpl.tool.api.domain.HttpResult;
import com.elitesland.cbpl.tool.cron.CronPatternUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.AllArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * @author eric.hao
 * @since 2024/08/09
 */
@Slf4j
@Api(tags = "定时任务组件接口")
@RestController
@RequestMapping("/schedule/common")
@AllArgsConstructor
public class SchedulingCommonController {

    /**
     * CRON表达式预览：列举当前时间后，20个匹配表达式的日期
     */
    @ApiOperation(value = "CRON表达式预览")
    @GetMapping(value = "/cron/preview")
    public HttpResult<List<String>> preview(String cronStr) {
        logger.info("[SCHEDULE] cron preview expression, cronStr = {}", cronStr);
        return HttpResult.ok(CronPatternUtils.preview(cronStr, 20));
    }
}
