package com.elitesland.cbpl.scheduling.registrar.service;

import cn.hutool.core.collection.ListUtil;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.spi.RosefinchStatusListener;
import com.elitesland.cbpl.scheduling.data.service.ScheduleConfigService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;

import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_BUSINESS_TAG;
import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_DELETION_TAG;

/**
 * @author eric.hao
 * @since 2024/08/13
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleStatusService implements RosefinchStatusListener {

    private final ScheduleConfigService scheduleConfigService;

    @Override
    public boolean supports(RosefinchConfigDetailVO rosefinchCfg) {
        List<String> status = ListUtil.of(SCHEDULE_BUSINESS_TAG, SCHEDULE_DELETION_TAG);
        return status.contains(rosefinchCfg.getTaskTag());
    }

    @Override
    public void active(RosefinchConfigDetailVO rosefinchCfg) {
        scheduleConfigService.activeByRosefinchId(rosefinchCfg.getId());
    }

    @Override
    public void inactive(RosefinchConfigDetailVO rosefinchCfg) {
        scheduleConfigService.inactiveByRosefinchId(rosefinchCfg.getId());
    }
}
