/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.registrar.task.InstanceDeletionTask;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.ScheduleInitialize;
import java.util.concurrent.ScheduledExecutorService;
import org.dromara.dynamictp.core.spring.EnableDynamicTp;
import org.dromara.dynamictp.core.support.ThreadPoolBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@EnableDynamicTp
@Configuration
@EnableConfigurationProperties(value={SchedulingProperties.class})
@ConditionalOnProperty(prefix="cbpl.schedule", name={"enabled"}, havingValue="true")
public class SchedulingAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingAutoConfiguration.class);

    @Bean
    @ConditionalOnBean(value={RosefinchConfigService.class})
    public DefaultSchedulingRegistrar defaultSchedulingRegistrar(RosefinchConfigService rosefinchConfigService) {
        logger.info("[SCHEDULE] Scheduling enabled.");
        return new DefaultSchedulingRegistrar(rosefinchConfigService);
    }

    @Bean
    public ScheduleInitialize scheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        ScheduleInitialize schedule = new ScheduleInitialize(schedulingRegistrar);
        logger.info("[SCHEDULE] Initialize finished.");
        return schedule;
    }

    @Bean
    @ConditionalOnClass(value={RosefinchConfigService.class, RosefinchInstanceService.class})
    public InstanceDeletionTask instanceDeletionTask(RosefinchConfigService rosefinchConfigService, RosefinchInstanceService rosefinchInstanceService) {
        return new InstanceDeletionTask(rosefinchConfigService, rosefinchInstanceService);
    }

    @Bean(value={"phoenixScheduleTp"})
    public ScheduledExecutorService phoenixScheduleTp(SchedulingProperties properties) {
        return ThreadPoolBuilder.newBuilder().threadPoolName("phoenixScheduleTp").threadFactory("phoenix-schedule-tp").corePoolSize(properties.getCorePoolSize()).maximumPoolSize(properties.getMaximumPoolSize()).queueCapacity(properties.getQueueCapacity()).rejectedExecutionHandler(properties.getRejectPolicy()).buildScheduled();
    }
}

