/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar.domain;

import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.ReflectUtil;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import com.elitesland.cbpl.tool.extra.spring.SpringUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.config.CronTask;
import org.springframework.util.ReflectionUtils;

@ApiModel(value="\u4efb\u52a1\u7ba1\u7406")
public class ScheduledTask
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(ScheduledTask.class);
    private static final long serialVersionUID = 1505663424771294166L;
    @ApiModelProperty(value="\u4efb\u52a1ID")
    private Long taskId;
    @ApiModelProperty(value="\u4efb\u52a1\u540d\u79f0")
    private String taskName;
    @ApiModelProperty(value="\u4efb\u52a1\u7f16\u7801")
    private String taskCode;
    @ApiModelProperty(value="\u7c7b\u540d")
    private String className;
    @ApiModelProperty(value="\u65b9\u6cd5\u540d")
    private String methodName;
    @ApiModelProperty(value="\u65b9\u6cd5\u53c2\u6570")
    private String customArgs;
    @ApiModelProperty(value="\u5b9a\u65f6\u4efb\u52a1\u8868\u8fbe\u5f0f")
    private String cron;
    @ApiModelProperty(value="\u89e6\u53d1\u4efb\u52a1")
    private CronTask triggerTask;

    public ScheduledTask createTriggerTask() {
        Assert.notBlank((CharSequence)this.className, (String)"\u7c7b\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.methodName, (String)"\u65b9\u6cd5\u540d\u5fc5\u586b", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.cron, (String)"\u8868\u8fbe\u5f0f\u5fc5\u586b", (Object[])new Object[0]);
        this.triggerTask = new CronTask(() -> {
            Object bean = SpringUtils.getClassBean((String)this.className);
            Object args = SchedulingUtil.parseArgs(this.customArgs);
            if (ObjectUtil.isNull((Object)args)) {
                Method method = ReflectionUtils.findMethod(bean.getClass(), (String)this.methodName);
                ReflectionUtils.invokeMethod((Method)method, (Object)bean);
            } else {
                ReflectUtil.invoke((Object)bean, (String)this.methodName, (Object[])new Object[]{args});
            }
        }, this.cron);
        return this;
    }

    ScheduledTask(Long taskId, String taskName, String taskCode, String className, String methodName, String customArgs, String cron, CronTask triggerTask) {
        this.taskId = taskId;
        this.taskName = taskName;
        this.taskCode = taskCode;
        this.className = className;
        this.methodName = methodName;
        this.customArgs = customArgs;
        this.cron = cron;
        this.triggerTask = triggerTask;
    }

    public static ScheduledTaskBuilder builder() {
        return new ScheduledTaskBuilder();
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getTaskCode() {
        return this.taskCode;
    }

    public String getClassName() {
        return this.className;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public String getCustomArgs() {
        return this.customArgs;
    }

    public String getCron() {
        return this.cron;
    }

    public CronTask getTriggerTask() {
        return this.triggerTask;
    }

    public void setTaskId(Long taskId) {
        this.taskId = taskId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setTaskCode(String taskCode) {
        this.taskCode = taskCode;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public void setCustomArgs(String customArgs) {
        this.customArgs = customArgs;
    }

    public void setCron(String cron) {
        this.cron = cron;
    }

    public void setTriggerTask(CronTask triggerTask) {
        this.triggerTask = triggerTask;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScheduledTask)) {
            return false;
        }
        ScheduledTask other = (ScheduledTask)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$taskId = this.getTaskId();
        Long other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !((Object)this$taskId).equals(other$taskId)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$taskCode = this.getTaskCode();
        String other$taskCode = other.getTaskCode();
        if (this$taskCode == null ? other$taskCode != null : !this$taskCode.equals(other$taskCode)) {
            return false;
        }
        String this$className = this.getClassName();
        String other$className = other.getClassName();
        if (this$className == null ? other$className != null : !this$className.equals(other$className)) {
            return false;
        }
        String this$methodName = this.getMethodName();
        String other$methodName = other.getMethodName();
        if (this$methodName == null ? other$methodName != null : !this$methodName.equals(other$methodName)) {
            return false;
        }
        String this$customArgs = this.getCustomArgs();
        String other$customArgs = other.getCustomArgs();
        if (this$customArgs == null ? other$customArgs != null : !this$customArgs.equals(other$customArgs)) {
            return false;
        }
        String this$cron = this.getCron();
        String other$cron = other.getCron();
        if (this$cron == null ? other$cron != null : !this$cron.equals(other$cron)) {
            return false;
        }
        CronTask this$triggerTask = this.getTriggerTask();
        CronTask other$triggerTask = other.getTriggerTask();
        return !(this$triggerTask == null ? other$triggerTask != null : !this$triggerTask.equals(other$triggerTask));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScheduledTask;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : ((Object)$taskId).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $taskCode = this.getTaskCode();
        result = result * 59 + ($taskCode == null ? 43 : $taskCode.hashCode());
        String $className = this.getClassName();
        result = result * 59 + ($className == null ? 43 : $className.hashCode());
        String $methodName = this.getMethodName();
        result = result * 59 + ($methodName == null ? 43 : $methodName.hashCode());
        String $customArgs = this.getCustomArgs();
        result = result * 59 + ($customArgs == null ? 43 : $customArgs.hashCode());
        String $cron = this.getCron();
        result = result * 59 + ($cron == null ? 43 : $cron.hashCode());
        CronTask $triggerTask = this.getTriggerTask();
        result = result * 59 + ($triggerTask == null ? 43 : $triggerTask.hashCode());
        return result;
    }

    public String toString() {
        return "ScheduledTask(taskId=" + this.getTaskId() + ", taskName=" + this.getTaskName() + ", taskCode=" + this.getTaskCode() + ", className=" + this.getClassName() + ", methodName=" + this.getMethodName() + ", customArgs=" + this.getCustomArgs() + ", cron=" + this.getCron() + ", triggerTask=" + this.getTriggerTask() + ")";
    }

    public static class ScheduledTaskBuilder {
        private Long taskId;
        private String taskName;
        private String taskCode;
        private String className;
        private String methodName;
        private String customArgs;
        private String cron;
        private CronTask triggerTask;

        ScheduledTaskBuilder() {
        }

        public ScheduledTaskBuilder taskId(Long taskId) {
            this.taskId = taskId;
            return this;
        }

        public ScheduledTaskBuilder taskName(String taskName) {
            this.taskName = taskName;
            return this;
        }

        public ScheduledTaskBuilder taskCode(String taskCode) {
            this.taskCode = taskCode;
            return this;
        }

        public ScheduledTaskBuilder className(String className) {
            this.className = className;
            return this;
        }

        public ScheduledTaskBuilder methodName(String methodName) {
            this.methodName = methodName;
            return this;
        }

        public ScheduledTaskBuilder customArgs(String customArgs) {
            this.customArgs = customArgs;
            return this;
        }

        public ScheduledTaskBuilder cron(String cron) {
            this.cron = cron;
            return this;
        }

        public ScheduledTaskBuilder triggerTask(CronTask triggerTask) {
            this.triggerTask = triggerTask;
            return this;
        }

        public ScheduledTask build() {
            return new ScheduledTask(this.taskId, this.taskName, this.taskCode, this.className, this.methodName, this.customArgs, this.cron, this.triggerTask);
        }

        public String toString() {
            return "ScheduledTask.ScheduledTaskBuilder(taskId=" + this.taskId + ", taskName=" + this.taskName + ", taskCode=" + this.taskCode + ", className=" + this.className + ", methodName=" + this.methodName + ", customArgs=" + this.customArgs + ", cron=" + this.cron + ", triggerTask=" + this.triggerTask + ")";
        }
    }
}

