package com.elitesland.cbpl.scheduling.controller;

import cn.hutool.core.util.ObjectUtil;
import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.scheduling.domain.InstanceStatus;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstancePagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Slf4j
@Api(tags = "任务实例")
@RestController
@RequestMapping("/schedule/instance")
@RequiredArgsConstructor
public class ScheduleInstanceController {

    private final ScheduleInstanceService scheduleInstanceService;
    @Autowired(required = false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @ApiOperation(value = "分页查询")
    @PostMapping(value = "/list")
    public ApiResult<PagingVO<ScheduleInstancePagingVO>> list(@RequestBody ScheduleInstancePagingParamVO query) {
        logger.info("[PHOENIX-SCHEDULE] query paging param = {}", query);
        return ApiResult.ok(scheduleInstanceService.scheduleInstancePageBy(query));
    }

    @ApiOperation(value = "立即终止")
    @PostMapping(value = "/stop")
    public ApiResult<Void> list(Long instanceId) {
        logger.info("[PHOENIX-SCHEDULE] stop immediately, instanceId = {}", instanceId);
        var instance = scheduleInstanceService.scheduleInstanceById(instanceId);
        if (!InstanceStatus.RUNNING.getCode().equals(instance.getInstanceStatus())) {
            throw new BusinessException(ApiCode.VALIDATE_FAILED, "当前实例状态(" + instance.getInstanceStatusName() + ")不能终止");
        }
        if (ObjectUtil.isNotNull(schedulingRegistrar)) {
            schedulingRegistrar.stopTriggerTask(instance.getTaskCode(), instanceId);
        }
        return ApiResult.ok();
    }
}
