package com.elitesland.cbpl.scheduling.convert;

import com.elitescloud.cloudt.core.common.BaseMapperConfig;
import com.elitesland.cbpl.scheduling.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScheduleConfigConvert {

	ScheduleConfigConvert INSTANCE = Mappers.getMapper(ScheduleConfigConvert.class);

    /**
     * DO => RespVO
     */
    ScheduleConfigDetailVO doToVO(ScheduleConfigDO scheduleConfigDO);

    /**
     * SaveParam => DO
     */
    ScheduleConfigDO saveParamToDO(ScheduleConfigSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(ScheduleConfigSaveParamVO saveParam, @MappingTarget ScheduleConfigDO scheduleConfigDO);

    /**
     * RespVO => DetailVO
     */
    ScheduleConfigDetailVO respToVO(ScheduleConfigRespVO scheduleConfigVO);
}
