package com.elitesland.cbpl.scheduling.domain;

import cn.hutool.extra.spring.SpringUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import lombok.extern.slf4j.Slf4j;
import org.springframework.scheduling.config.TriggerTask;
import org.springframework.scheduling.support.CronTrigger;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Method;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@Slf4j
@Builder
@ApiModel("任务管理")
public class ScheduledTask {

    @ApiModelProperty("任务ID")
    private Long taskId;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务编码")
    private String taskCode;

    @ApiModelProperty("触发任务")
    private TriggerTask triggerTask;

    public ScheduledTask setTrigger(String className, String methodName, String cron) {
        triggerTask = new TriggerTask(
                // 执行定时任务
                () -> {
                    Object bean = SpringUtil.getBean(className);
                    Method method = ReflectionUtils.findMethod(bean.getClass(), methodName);
                    ReflectionUtils.invokeMethod(method, bean);
                },
                // 设置触发器
                triggerContext -> {
                    // 初始化定时任务周期
                    CronTrigger trigger = new CronTrigger(cron);
                    return trigger.nextExecutionTime(triggerContext);
                }
        );
        return this;
    }
}
