package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.InitializingBean;

import javax.annotation.Resource;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/09/07
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleInitialize implements InitializingBean {

    @Resource
    private ScheduleConfigService scheduleConfigService;
    private final DefaultSchedulingRegistrar schedulingRegistrar;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                // 等待任务调度初始化完成
                while (!schedulingRegistrar.initializeCompleted()) {
                    Thread.sleep(100);
                }
                var query = new ScheduleConfigQueryParamVO();
                query.setActiveFlag("1");
                List<ScheduledTask> tasks = scheduleConfigService.scheduleConfigByParam(query);
                tasks.forEach(schedulingRegistrar::addTriggerTask);
            } catch (Exception e) {
                logger.error("[PHOENIX-SCHEDULE] schedule initialize failed: {}", ExceptionUtils.formatException(e));
            }
        }).start();
    }
}
