package com.elitesland.cbpl.scheduling.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.scheduling.entity.QScheduleConfigDO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Component
@RequiredArgsConstructor
public class ScheduleConfigRepoProc {

    private final JPAQueryFactory jpaQueryFactory;
    private static final QScheduleConfigDO scheduleConfigDO = QScheduleConfigDO.scheduleConfigDO;

    private final QBean<ScheduleConfigPagingVO> scheduleConfigPagingVO = Projections.bean(
            ScheduleConfigPagingVO.class,
            scheduleConfigDO.id,
            scheduleConfigDO.taskName,
            scheduleConfigDO.taskCode,
            scheduleConfigDO.className,
            scheduleConfigDO.method,
            scheduleConfigDO.cron,
            scheduleConfigDO.activeFlag,
            scheduleConfigDO.tenantId,
            scheduleConfigDO.belongOrgId,
            scheduleConfigDO.tenantOrgId,
            scheduleConfigDO.remark,
            scheduleConfigDO.createUserId,
            scheduleConfigDO.creator,
            scheduleConfigDO.createTime,
            scheduleConfigDO.modifyUserId,
            scheduleConfigDO.updater,
            scheduleConfigDO.modifyTime,
            scheduleConfigDO.deleteFlag,
            scheduleConfigDO.auditDataVersion,
            scheduleConfigDO.secBuId,
            scheduleConfigDO.secUserId,
            scheduleConfigDO.secOuId
    );

    private Predicate pagingWhere(ScheduleConfigPagingParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scheduleConfigDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(scheduleConfigDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTaskName())) {
            predicates.add(scheduleConfigDO.taskName.eq(query.getTaskName()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(scheduleConfigDO.taskCode.eq(query.getTaskCode()));
        }
        if (StrUtil.isNotBlank(query.getClassName())) {
            predicates.add(scheduleConfigDO.className.eq(query.getClassName()));
        }
        if (StrUtil.isNotBlank(query.getMethod())) {
            predicates.add(scheduleConfigDO.method.eq(query.getMethod()));
        }
        if (StrUtil.isNotBlank(query.getCron())) {
            predicates.add(scheduleConfigDO.cron.eq(query.getCron()));
        }
        if (StrUtil.isNotBlank(query.getActiveFlag())) {
            predicates.add(scheduleConfigDO.activeFlag.eq(query.getActiveFlag()));
        }
        if (ObjectUtil.isNotNull(query.getTenantId())) {
            predicates.add(scheduleConfigDO.tenantId.eq(query.getTenantId()));
        }
        if (ObjectUtil.isNotNull(query.getBelongOrgId())) {
            predicates.add(scheduleConfigDO.belongOrgId.eq(query.getBelongOrgId()));
        }
        if (ObjectUtil.isNotNull(query.getTenantOrgId())) {
            predicates.add(scheduleConfigDO.tenantOrgId.eq(query.getTenantOrgId()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(scheduleConfigDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(scheduleConfigDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(scheduleConfigDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(scheduleConfigDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(scheduleConfigDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(scheduleConfigDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(scheduleConfigDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(scheduleConfigDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        if (ObjectUtil.isNotNull(query.getAuditDataVersion())) {
            predicates.add(scheduleConfigDO.auditDataVersion.eq(query.getAuditDataVersion()));
        }
        if (ObjectUtil.isNotNull(query.getSecBuId())) {
            predicates.add(scheduleConfigDO.secBuId.eq(query.getSecBuId()));
        }
        if (ObjectUtil.isNotNull(query.getSecUserId())) {
            predicates.add(scheduleConfigDO.secUserId.eq(query.getSecUserId()));
        }
        if (ObjectUtil.isNotNull(query.getSecOuId())) {
            predicates.add(scheduleConfigDO.secOuId.eq(query.getSecOuId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long scheduleConfigCountBy(ScheduleConfigPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(scheduleConfigDO.id)
                .from(scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        var jpaQuery = jpaQueryFactory.select(scheduleConfigPagingVO)
                .from(scheduleConfigDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private final QBean<ScheduleConfigRespVO> scheduleConfigVO = Projections.bean(
            ScheduleConfigRespVO.class,
            scheduleConfigDO.id,
            scheduleConfigDO.taskName,
            scheduleConfigDO.taskCode,
            scheduleConfigDO.className,
            scheduleConfigDO.method,
            scheduleConfigDO.cron,
            scheduleConfigDO.activeFlag,
            scheduleConfigDO.tenantId,
            scheduleConfigDO.belongOrgId,
            scheduleConfigDO.tenantOrgId,
            scheduleConfigDO.remark,
            scheduleConfigDO.createUserId,
            scheduleConfigDO.creator,
            scheduleConfigDO.createTime,
            scheduleConfigDO.modifyUserId,
            scheduleConfigDO.updater,
            scheduleConfigDO.modifyTime,
            scheduleConfigDO.deleteFlag,
            scheduleConfigDO.auditDataVersion,
            scheduleConfigDO.secBuId,
            scheduleConfigDO.secUserId,
            scheduleConfigDO.secOuId
    );

    private Predicate where(ScheduleConfigQueryParamVO query) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scheduleConfigDO.deleteFlag.eq(0));
        if (ObjectUtil.isNotNull(query.getId())) {
            predicates.add(scheduleConfigDO.id.eq(query.getId()));
        }
        if (StrUtil.isNotBlank(query.getTaskName())) {
            predicates.add(scheduleConfigDO.taskName.eq(query.getTaskName()));
        }
        if (StrUtil.isNotBlank(query.getTaskCode())) {
            predicates.add(scheduleConfigDO.taskCode.eq(query.getTaskCode()));
        }
        if (StrUtil.isNotBlank(query.getClassName())) {
            predicates.add(scheduleConfigDO.className.eq(query.getClassName()));
        }
        if (StrUtil.isNotBlank(query.getMethod())) {
            predicates.add(scheduleConfigDO.method.eq(query.getMethod()));
        }
        if (StrUtil.isNotBlank(query.getCron())) {
            predicates.add(scheduleConfigDO.cron.eq(query.getCron()));
        }
        if (StrUtil.isNotBlank(query.getActiveFlag())) {
            predicates.add(scheduleConfigDO.activeFlag.eq(query.getActiveFlag()));
        }
        if (ObjectUtil.isNotNull(query.getTenantId())) {
            predicates.add(scheduleConfigDO.tenantId.eq(query.getTenantId()));
        }
        if (ObjectUtil.isNotNull(query.getBelongOrgId())) {
            predicates.add(scheduleConfigDO.belongOrgId.eq(query.getBelongOrgId()));
        }
        if (ObjectUtil.isNotNull(query.getTenantOrgId())) {
            predicates.add(scheduleConfigDO.tenantOrgId.eq(query.getTenantOrgId()));
        }
        if (StrUtil.isNotBlank(query.getRemark())) {
            predicates.add(scheduleConfigDO.remark.eq(query.getRemark()));
        }
        if (ObjectUtil.isNotNull(query.getCreateUserId())) {
            predicates.add(scheduleConfigDO.createUserId.eq(query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank(query.getCreator())) {
            predicates.add(scheduleConfigDO.creator.eq(query.getCreator()));
        }
        if (ObjectUtil.isNotNull(query.getCreateTime())) {
            predicates.add(scheduleConfigDO.createTime.eq(query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull(query.getModifyUserId())) {
            predicates.add(scheduleConfigDO.modifyUserId.eq(query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank(query.getUpdater())) {
            predicates.add(scheduleConfigDO.updater.eq(query.getUpdater()));
        }
        if (ObjectUtil.isNotNull(query.getModifyTime())) {
            predicates.add(scheduleConfigDO.modifyTime.eq(query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull(query.getDeleteFlag())) {
            predicates.add(scheduleConfigDO.deleteFlag.eq(query.getDeleteFlag()));
        }
        if (ObjectUtil.isNotNull(query.getAuditDataVersion())) {
            predicates.add(scheduleConfigDO.auditDataVersion.eq(query.getAuditDataVersion()));
        }
        if (ObjectUtil.isNotNull(query.getSecBuId())) {
            predicates.add(scheduleConfigDO.secBuId.eq(query.getSecBuId()));
        }
        if (ObjectUtil.isNotNull(query.getSecUserId())) {
            predicates.add(scheduleConfigDO.secUserId.eq(query.getSecUserId()));
        }
        if (ObjectUtil.isNotNull(query.getSecOuId())) {
            predicates.add(scheduleConfigDO.secOuId.eq(query.getSecOuId()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScheduleConfigRespVO> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        var jpaQuery = jpaQueryFactory.select(scheduleConfigVO)
                .from(scheduleConfigDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = jpaQueryFactory.update(scheduleConfigDO)
                .set(scheduleConfigDO.deleteFlag, 1)
                .where(scheduleConfigDO.id.in(ids));
        return update.execute();
    }

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    public long updateStatus(Long id, String status) {
        JPAUpdateClause update = jpaQueryFactory.update(scheduleConfigDO)
                .set(scheduleConfigDO.activeFlag, status)
                .where(scheduleConfigDO.id.eq(id));
        return update.execute();
    }

    public ScheduleConfigRespVO findById(Long taskId) {
        List<Predicate> predicates = new ArrayList<>();
        predicates.add(scheduleConfigDO.id.eq(taskId));
        var jpaQuery = jpaQueryFactory.select(scheduleConfigVO)
                .from(scheduleConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return jpaQuery.fetchOne();
    }
}
