package com.elitesland.cbpl.scheduling.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
public interface ScheduleConfigService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ScheduleConfigDetailVO scheduleConfigById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ScheduleConfigSaveParamVO saveParam);

    /**
     * 更新状态
     *
     * @param id     业务单据ID
     * @param status 更新状态
     */
    void updateStatus(Long id, String status);

    /**
     * 批量逻辑删除
     *
     * @param ids 业务单据ID
     * @return 更新成功的数量
     */
    long updateDeleteFlag(List<Long> ids);

    /**
     * 立即执行一次
     *
     * @param taskId 任务主键id
     */
    void execute(Long taskId);

    /**
     * CRON表达式预览：列举当前时间后，20个匹配表达式的日期
     *
     * @param taskId 任务主键id
     * @return 实例列表
     */
    List<String> preview(Long taskId);
}
