package com.elitesland.cbpl.scheduling.service.impl;

import com.elitescloud.boot.exception.BusinessException;
import com.elitescloud.cloudt.common.annotation.SysCodeProc;
import com.elitescloud.cloudt.common.base.ApiCode;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.scheduling.convert.ScheduleInstanceConvert;
import com.elitesland.cbpl.scheduling.entity.ScheduleInstanceDO;
import com.elitesland.cbpl.scheduling.repo.ScheduleInstanceRepo;
import com.elitesland.cbpl.scheduling.repo.ScheduleInstanceRepoProc;
import com.elitesland.cbpl.scheduling.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstancePagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceRespVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Optional;

/**
 * @author eric.hao
 * @since 2023/09/12
 */
@Slf4j
@Service
@RequiredArgsConstructor
public class ScheduleInstanceServiceImpl implements ScheduleInstanceService {

    private final ScheduleInstanceRepo scheduleInstanceRepo;
    private final ScheduleInstanceRepoProc scheduleInstanceRepoProc;

    @SysCodeProc
    @Override
    public PagingVO<ScheduleInstancePagingVO> scheduleInstancePageBy(ScheduleInstancePagingParamVO query) {
        long count = scheduleInstanceRepoProc.scheduleInstanceCountBy(query);
        if (count > 0) {
            var list = scheduleInstanceRepoProc.scheduleInstancePageBy(query);
            return new PagingVO<>(count, list);
        }
        return new PagingVO<>();
    }

    @SysCodeProc
    @Override
    public List<ScheduleInstanceRespVO> scheduleInstanceByParam(ScheduleInstanceQueryParamVO query) {
        return scheduleInstanceRepoProc.scheduleInstanceByParam(query);
    }

    @SysCodeProc
    @Override
    public ScheduleInstanceDetailVO scheduleInstanceById(Long id) {
        ScheduleInstanceRespVO respVO = scheduleInstanceRepoProc.findById(id);
        return ScheduleInstanceConvert.INSTANCE.respToVO(respVO);
    }

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
    @Override
    public Long save(ScheduleInstanceSaveParamVO saveParam) {
        // 新增
        if (saveParam.isNew()) {
            ScheduleInstanceDO scheduleInstanceDO = ScheduleInstanceConvert.INSTANCE.saveParamToDO(saveParam);
            scheduleInstanceRepo.save(scheduleInstanceDO);
            return scheduleInstanceDO.getId();
        }
        // 修改
        else {
            Optional<ScheduleInstanceDO> scheduleInstanceDO = scheduleInstanceRepo.findById(saveParam.getId());
            if (scheduleInstanceDO.isEmpty()) {
                throw new BusinessException(ApiCode.NOT_FOUND_DATA, "Not Found Data");
            }
            ScheduleInstanceDO scheduleInstance = scheduleInstanceDO.get();
            ScheduleInstanceConvert.INSTANCE.saveParamMergeToDO(saveParam, scheduleInstance);
            scheduleInstanceRepo.save(scheduleInstance);
            return scheduleInstance.getId();
        }
    }

    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(ScheduleInstanceSaveParamVO saveParam) {
        scheduleInstanceRepoProc.update(saveParam);
    }
}
