package com.elitesland.cbpl.scheduling.vo.param;

import cn.hutool.core.util.ObjectUtil;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ApiModel("定时任务配置表")
public class ScheduleConfigSaveParamVO {

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "定时任务表达式")
	private String cron;

	@ApiModelProperty(value = "启用标记")
	private String activeFlag;

	@ApiModelProperty(value = "所属租户ID")
	private Long tenantId;

	@ApiModelProperty(value = "所属组织ID")
	private Long belongOrgId;

	@ApiModelProperty(value = "租户组织ID")
	private Long tenantOrgId;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者ID")
	private Long createUserId;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者ID")
	private Long modifyUserId;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;

	@ApiModelProperty(value = "删除标记")
	private Integer deleteFlag;

	@ApiModelProperty(value = "锁版本")
	private Integer auditDataVersion;

	@ApiModelProperty(value = "数据归属组织id")
	private Long secBuId;

	@ApiModelProperty(value = "数据归属雇员id")
	private Long secUserId;

	@ApiModelProperty(value = "数据归属公司id")
	private Long secOuId;

	public boolean isNew() {
		return ObjectUtil.isNull(id);
	}
}
