package com.elitesland.cbpl.scheduling.vo.resp;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * 定时任务配置表
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ApiModel("定时任务配置表")
public class ScheduleConfigPagingVO implements Serializable {

	private static final long serialVersionUID = 552105911287335548L;

	@ApiModelProperty(value = "主键")
	private Long id;

	@ApiModelProperty(value = "定时任务名称")
	private String taskName;

	@ApiModelProperty(value = "定时任务编码")
	private String taskCode;

	@ApiModelProperty(value = "类名")
	private String className;

	@ApiModelProperty(value = "方法名")
	private String method;

	@ApiModelProperty(value = "定时任务表达式")
	private String cron;

	@ApiModelProperty(value = "启用标记")
	private String activeFlag;

	@ApiModelProperty(value = "备注")
	private String remark;

	@ApiModelProperty(value = "记录创建者")
	private String creator;

	@ApiModelProperty(value = "记录创建时间")
	private LocalDateTime createTime;

	@ApiModelProperty(value = "记录最后更新者")
	private String updater;

	@ApiModelProperty(value = "记录最后更新时间")
	private LocalDateTime modifyTime;
}
