/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.controller;

import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/schedule/config"})
public class ScheduleConfigController {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleConfigController.class);
    private final ScheduleConfigService scheduleConfigService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public ApiResult<PagingVO<ScheduleConfigPagingVO>> list(@RequestBody ScheduleConfigPagingParamVO query) {
        logger.info("[PHOENIX-SCHEDULE] query paging param = {}", (Object)query);
        return ApiResult.ok(this.scheduleConfigService.scheduleConfigPageBy(query));
    }

    @ApiOperation(value="\u660e\u7ec6\u67e5\u8be2")
    @GetMapping(value={"/detail/{id}"})
    public ApiResult<ScheduleConfigDetailVO> detail(@PathVariable(value="id") Long id) {
        logger.info("[PHOENIX-SCHEDULE] query detail by id = {}", (Object)id);
        return ApiResult.ok((Object)this.scheduleConfigService.scheduleConfigById(id));
    }

    @ApiOperation(value="\u65b0\u589e\u6216\u4fee\u6539")
    @PostMapping(value={"/save"})
    public ApiResult<Long> save(@RequestBody ScheduleConfigSaveParamVO saveParam) {
        logger.info("[PHOENIX-SCHEDULE] create/update record, saveParam = {}", (Object)saveParam);
        return ApiResult.ok((Object)this.scheduleConfigService.save(saveParam));
    }

    @ApiOperation(value="\u542f\u7528")
    @PatchMapping(value={"/{id}/v"})
    public ApiResult<Void> active(@PathVariable(value="id") Long id) {
        logger.info("[PHOENIX-SCHEDULE] active by id = {}", (Object)id);
        this.scheduleConfigService.updateStatus(id, "1");
        return ApiResult.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PatchMapping(value={"/{id}/x"})
    public ApiResult<Void> inactive(@PathVariable(value="id") Long id) {
        logger.info("[PHOENIX-SCHEDULE] inactive by id = {}", (Object)id);
        this.scheduleConfigService.updateStatus(id, "0");
        return ApiResult.ok();
    }

    @ApiOperation(value="\u6279\u91cf\u903b\u8f91\u5220\u9664")
    @PutMapping(value={"/delete"})
    public ApiResult<Void> updateDeleteFlag(@RequestBody List<Long> ids) {
        logger.info("[PHOENIX-SCHEDULE] batch logic delete by ids = {}", ids);
        this.scheduleConfigService.updateDeleteFlag(ids);
        return ApiResult.ok();
    }

    @ApiOperation(value="\u7acb\u5373\u6267\u884c\u4e00\u6b21")
    @PostMapping(value={"/execute"})
    public ApiResult<Void> execute(Long taskId) {
        logger.info("[PHOENIX-SCHEDULE] execute immediately, taskId = {}", (Object)taskId);
        this.scheduleConfigService.execute(taskId);
        return ApiResult.ok();
    }

    @ApiOperation(value="CRON\u8868\u8fbe\u5f0f\u9884\u89c8")
    @GetMapping(value={"/cron/preview"})
    public ApiResult<List<String>> preview(Long taskId) {
        logger.info("[PHOENIX-SCHEDULE] cron preview, taskId = {}", (Object)taskId);
        return ApiResult.ok(this.scheduleConfigService.preview(taskId));
    }

    public ScheduleConfigController(ScheduleConfigService scheduleConfigService) {
        this.scheduleConfigService = scheduleConfigService;
    }
}

