/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.service;

import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.cloudt.tenant.TenantWrapper;
import com.elitesland.cbpl.scheduling.convert.ScheduleInstanceConvert;
import com.elitesland.cbpl.scheduling.domain.InstanceStatus;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.spi.ScheduleCompleteProvider;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleExecuteHandler.class);
    @Resource
    private TenantWrapper tenantWrapper;
    @Resource
    private ScheduleInstanceService scheduleInstanceService;
    @Autowired(required=false)
    private ScheduleCompleteProvider scheduleCompleteProvider;

    public Runnable runAuto(ScheduledTask task) {
        return () -> this.runImmediately(task, "\u81ea\u52a8\u6267\u884c");
    }

    public void runImmediately(ScheduledTask task) {
        this.runImmediately(task, "\u624b\u52a8\u6267\u884c");
    }

    public void runImmediately(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO instance = this.instanceLog(task, runType);
        this.updateInstanceStatus(instance, task.getTriggerTask().getRunnable());
    }

    private ScheduleInstanceSaveParamVO instanceLog(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
        saveParam.setMasId(task.getTaskId());
        saveParam.setTaskCode(task.getTaskCode());
        saveParam.setTaskName(task.getTaskName());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setInstanceStatus(InstanceStatus.RUNNING.getCode());
        saveParam.setRemark(runType);
        Long instanceId = this.scheduleInstanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    private void updateInstanceStatus(ScheduleInstanceSaveParamVO instance, Runnable runnable) {
        CompletableFuture future = this.tenantWrapper.runAsync(runnable);
        future.whenComplete((resp, ex) -> {
            instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
            if (ObjectUtil.isNotNull((Object)ex)) {
                instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
                instance.setErrorMessage(ExceptionUtils.formatException((Throwable)ex, (int)255));
            }
            instance.setEndTime(LocalDateTime.now());
            this.scheduleInstanceService.update(instance);
            try {
                if (this.scheduleCompleteProvider != null) {
                    ScheduleInstanceRespVO response = ScheduleInstanceConvert.INSTANCE.saveParamToVO(instance);
                    this.scheduleCompleteProvider.whenComplete(response, (Throwable)ex);
                }
            }
            catch (Exception e) {
                logger.error("[PHOENIX-SCHEDULE] execute complete callback error.", (Throwable)e);
            }
        });
    }

    public void stopImmediately(Long instanceId, boolean stopTag) {
        try {
            ScheduleInstanceDetailVO instance = this.scheduleInstanceService.scheduleInstanceById(instanceId);
            ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
            saveParam.setId(instanceId);
            saveParam.setEndTime(LocalDateTime.now());
            saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
            saveParam.setRemark(instance.getRemark() + " \u624b\u52a8\u7ec8\u6b62\uff0c\u662f\u5426\u7ec8\u6b62\u6210\u529f\uff1a" + stopTag + "\uff1b");
            this.scheduleInstanceService.update(saveParam);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] stop immediately unexpected error.", (Throwable)e);
        }
    }
}

