package com.elitesland.cbpl.scheduling.config;

import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.ScheduleInitialize;
import com.elitesland.cbpl.scheduling.service.ScheduleExecuteHandler;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(SchedulingProperties.class)
@ConditionalOnProperty(prefix = SCHEDULE_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class SchedulingAutoConfiguration {

    @Bean
    public ScheduleExecuteHandler scheduleExecuteHandler() {
        return new ScheduleExecuteHandler();
    }

    @Bean
    public DefaultSchedulingRegistrar defaultSchedulingRegistrar(ScheduleExecuteHandler scheduleExecuteHandler) {
        logger.info("[PHOENIX-SCHEDULE] Scheduling enabled.");
        return new DefaultSchedulingRegistrar(scheduleExecuteHandler);
    }

    @Bean
    public ScheduleInitialize scheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        logger.info("[PHOENIX-SCHEDULE] Scheduling Initialize loading...");
        var schedule = new ScheduleInitialize(schedulingRegistrar);
        logger.info("[PHOENIX-SCHEDULE] Scheduling Initialize finished.");
        return schedule;
    }
}
