/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar;

import cn.hutool.core.collection.ConcurrentHashSet;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.service.ScheduleExecuteHandler;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.SchedulingException;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.annotation.SchedulingConfigurer;
import org.springframework.scheduling.config.ScheduledTaskRegistrar;

public class DefaultSchedulingRegistrar
implements SchedulingConfigurer {
    private static final Logger logger = LoggerFactory.getLogger(DefaultSchedulingRegistrar.class);
    private final ScheduleExecuteHandler scheduleExecuteHandler;
    private ScheduledTaskRegistrar taskRegistrar;
    private Set<ScheduledFuture<?>> scheduledFutures;
    private final Map<String, ScheduledFuture<?>> taskFutures = new ConcurrentHashMap();

    public void configureTasks(@NotNull ScheduledTaskRegistrar taskRegistrar) {
        this.taskRegistrar = taskRegistrar;
    }

    private Set<ScheduledFuture<?>> getScheduledFutures() {
        if (this.scheduledFutures == null) {
            this.scheduledFutures = new ConcurrentHashSet();
        }
        return this.scheduledFutures;
    }

    public void runImmediately(ScheduledTask task) {
        this.scheduleExecuteHandler.runImmediately(task);
    }

    public void addTriggerTask(ScheduledTask task) {
        String taskFutureKey = this.taskFutureKey(task.getTaskCode());
        if (this.taskFutures.containsKey(taskFutureKey)) {
            throw new SchedulingException("[PHOENIX-SCHEDULE] taskCode[" + task.getTaskCode() + "] was added.");
        }
        TaskScheduler scheduler = this.taskRegistrar.getScheduler();
        ScheduledFuture future = scheduler.schedule(this.scheduleExecuteHandler.runAuto(task), task.getTriggerTask().getTrigger());
        this.getScheduledFutures().add(future);
        this.taskFutures.put(taskFutureKey, future);
        logger.info("[PHOENIX-SCHEDULE] add taskCode[{}] success.", (Object)task.getTaskCode());
    }

    public void cancelTriggerTask(ScheduledTask task) {
        if (!this.hasTask(task.getTaskCode())) {
            logger.info("[PHOENIX-SCHEDULE] taskCode[{}] not exist to cancel.", (Object)task.getTaskCode());
            return;
        }
        boolean cancelTag = this.stopImmediately(task.getTaskCode(), false);
        logger.info("[PHOENIX-SCHEDULE] taskCode[{}] canceled {}.", (Object)task.getTaskCode(), (Object)cancelTag);
    }

    public boolean stopTriggerTask(String taskCode, Long instanceId) {
        if (!this.hasTask(taskCode)) {
            logger.warn("[PHOENIX-SCHEDULE] taskCode[{}] not exist to stop.", (Object)taskCode);
            return true;
        }
        boolean stopTag = this.stopImmediately(taskCode, true);
        this.scheduleExecuteHandler.stopImmediately(instanceId, stopTag);
        logger.info("[PHOENIX-SCHEDULE] taskCode[{}] stopped {}.", (Object)taskCode, (Object)stopTag);
        return stopTag;
    }

    private boolean stopImmediately(String taskCode, boolean mayInterruptIfRunning) {
        String taskFutureKey = this.taskFutureKey(taskCode);
        ScheduledFuture<?> future = this.taskFutures.get(taskFutureKey);
        boolean cancelTag = future.cancel(mayInterruptIfRunning);
        this.taskFutures.remove(taskFutureKey);
        this.getScheduledFutures().remove(future);
        return cancelTag;
    }

    public void resetTriggerTask(ScheduledTask task) {
        this.cancelTriggerTask(task);
        this.addTriggerTask(task);
    }

    public Set<String> taskCodes() {
        return this.taskFutures.keySet();
    }

    public boolean hasTask(String taskCode) {
        return this.taskFutures.containsKey(this.taskFutureKey(taskCode));
    }

    public boolean initializeCompleted() {
        return this.taskRegistrar != null && this.taskRegistrar.getScheduler() != null;
    }

    private String taskFutureKey(String taskCode) {
        return TenantSpiUtil.currentTenantCode() + taskCode;
    }

    public DefaultSchedulingRegistrar(ScheduleExecuteHandler scheduleExecuteHandler) {
        this.scheduleExecuteHandler = scheduleExecuteHandler;
    }
}

