/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar;

import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.service.ScheduleConfigService;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleInitialize
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleInitialize.class);
    @Autowired(required=false)
    private TenantClientSpi tenantClientSpi;
    @Resource
    private ScheduleConfigService scheduleConfigService;
    private final DefaultSchedulingRegistrar schedulingRegistrar;

    public void afterPropertiesSet() {
        new Thread(() -> {
            try {
                while (!this.schedulingRegistrar.initializeCompleted()) {
                    Thread.sleep(100L);
                }
                ScheduleConfigQueryParamVO query = new ScheduleConfigQueryParamVO();
                query.setActiveFlag("1");
                Runnable runnable = () -> {
                    List<ScheduledTask> tasks = this.scheduleConfigService.scheduleConfigByParam(query);
                    tasks.forEach(this.schedulingRegistrar::addTriggerTask);
                };
                if (this.tenantClientSpi == null) {
                    runnable.run();
                } else {
                    this.tenantClientSpi.byTenants(runnable);
                }
            }
            catch (Exception e) {
                logger.error("[PHOENIX-SCHEDULE] schedule initialize failed: {}", (Object)ExceptionUtils.formatException((Throwable)e));
            }
        }).start();
    }

    public ScheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        this.schedulingRegistrar = schedulingRegistrar;
    }
}

