/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.scheduling.entity.QScheduleConfigDO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleConfigRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScheduleConfigRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScheduleConfigDO scheduleConfigDO = QScheduleConfigDO.scheduleConfigDO;
    private final QBean<ScheduleConfigPagingVO> scheduleConfigPagingVO;
    private final QBean<ScheduleConfigRespVO> scheduleConfigVO;

    private Predicate pagingWhere(ScheduleConfigPagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)query.getId()));
        }
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getClassName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.className.eq((Object)query.getClassName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getMethod())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.method.eq((Object)query.getMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCron())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.cron.eq((Object)query.getCron()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getActiveFlag())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.activeFlag.eq((Object)query.getActiveFlag()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.remark.eq((Object)query.getRemark()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateUserId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCreator())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.creator.eq((Object)query.getCreator()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateTime())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.createTime.eq((Object)query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyUserId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.modifyUserId.eq((Object)query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUpdater())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.updater.eq((Object)query.getUpdater()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyTime())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.modifyTime.eq((Object)query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getDeleteFlag())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long scheduleConfigCountBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(ScheduleConfigRepoProc.scheduleConfigDO.id).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.scheduleConfigPagingVO).from((EntityPath)scheduleConfigDO);
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(ScheduleConfigQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)query.getId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.eq((Object)query.getTaskName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getClassName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.className.eq((Object)query.getClassName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getMethod())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.method.eq((Object)query.getMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCron())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.cron.eq((Object)query.getCron()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getActiveFlag())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.activeFlag.eq((Object)query.getActiveFlag()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.remark.eq((Object)query.getRemark()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateUserId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCreator())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.creator.eq((Object)query.getCreator()));
        }
        if (ObjectUtil.isNotNull((Object)query.getCreateTime())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.createTime.eq((Object)query.getCreateTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyUserId())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.modifyUserId.eq((Object)query.getModifyUserId()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getUpdater())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.updater.eq((Object)query.getUpdater()));
        }
        if (ObjectUtil.isNotNull((Object)query.getModifyTime())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.modifyTime.eq((Object)query.getModifyTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getDeleteFlag())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)query.getDeleteFlag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScheduleConfigRespVO> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.scheduleConfigVO).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleConfigDO).set(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag, (Object)1).where(new Predicate[]{ScheduleConfigRepoProc.scheduleConfigDO.id.in(ids)});
        return update.execute();
    }

    public long updateStatus(Long id, String status) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleConfigDO).set((Path)ScheduleConfigRepoProc.scheduleConfigDO.activeFlag, (Object)status).where(new Predicate[]{ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)id)});
        return update.execute();
    }

    public ScheduleConfigRespVO findById(Long taskId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)taskId));
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.scheduleConfigVO).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return (ScheduleConfigRespVO)jpaQuery.fetchOne();
    }

    public boolean existsByCode(Long taskId, String taskCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)taskCode));
        if (ObjectUtil.isNotNull((Object)taskId)) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.ne((Object)taskId));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(this.scheduleConfigVO).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }

    public ScheduleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.scheduleConfigPagingVO = Projections.bean(ScheduleConfigPagingVO.class, (Expression[])new Expression[]{ScheduleConfigRepoProc.scheduleConfigDO.id, ScheduleConfigRepoProc.scheduleConfigDO.taskName, ScheduleConfigRepoProc.scheduleConfigDO.taskCode, ScheduleConfigRepoProc.scheduleConfigDO.className, ScheduleConfigRepoProc.scheduleConfigDO.method, ScheduleConfigRepoProc.scheduleConfigDO.cron, ScheduleConfigRepoProc.scheduleConfigDO.activeFlag, ScheduleConfigRepoProc.scheduleConfigDO.remark, ScheduleConfigRepoProc.scheduleConfigDO.createUserId, ScheduleConfigRepoProc.scheduleConfigDO.creator, ScheduleConfigRepoProc.scheduleConfigDO.createTime, ScheduleConfigRepoProc.scheduleConfigDO.modifyUserId, ScheduleConfigRepoProc.scheduleConfigDO.updater, ScheduleConfigRepoProc.scheduleConfigDO.modifyTime, ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag});
        this.scheduleConfigVO = Projections.bean(ScheduleConfigRespVO.class, (Expression[])new Expression[]{ScheduleConfigRepoProc.scheduleConfigDO.id, ScheduleConfigRepoProc.scheduleConfigDO.taskName, ScheduleConfigRepoProc.scheduleConfigDO.taskCode, ScheduleConfigRepoProc.scheduleConfigDO.className, ScheduleConfigRepoProc.scheduleConfigDO.method, ScheduleConfigRepoProc.scheduleConfigDO.cron, ScheduleConfigRepoProc.scheduleConfigDO.activeFlag, ScheduleConfigRepoProc.scheduleConfigDO.remark, ScheduleConfigRepoProc.scheduleConfigDO.createUserId, ScheduleConfigRepoProc.scheduleConfigDO.creator, ScheduleConfigRepoProc.scheduleConfigDO.createTime, ScheduleConfigRepoProc.scheduleConfigDO.modifyUserId, ScheduleConfigRepoProc.scheduleConfigDO.updater, ScheduleConfigRepoProc.scheduleConfigDO.modifyTime, ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

