/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.scheduling.entity.QScheduleConfigDO;
import com.elitesland.cbpl.scheduling.entity.QScheduleInstanceDO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstancePagingParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceQueryParamVO;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstancePagingVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScheduleInstanceRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QScheduleConfigDO scheduleConfigDO = QScheduleConfigDO.scheduleConfigDO;
    private static final QScheduleInstanceDO scheduleInstanceDO = QScheduleInstanceDO.scheduleInstanceDO;
    private final QBean<ScheduleInstancePagingVO> scheduleInstancePagingVO;
    private final QBean<ScheduleInstanceRespVO> scheduleInstanceVO;

    private Predicate pagingWhere(ScheduleInstancePagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(ScheduleInstanceRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getInstanceStatus())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.instanceStatus.eq((Object)query.getInstanceStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getErrorMessage());
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.errorMessage.like(likeStr));
        }
        if (ObjectUtil.isNotNull((Object)query.getStartTime())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.startTime.goe((Comparable)query.getStartTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getEndTime())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.endTime.loe((Comparable)query.getEndTime()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getRemark());
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.remark.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long scheduleInstanceCountBy(ScheduleInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScheduleInstanceRepoProc.scheduleInstanceDO.id).from((EntityPath)scheduleInstanceDO)).leftJoin((EntityPath)scheduleConfigDO)).on((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.id.eq(ScheduleInstanceRepoProc.scheduleInstanceDO.masId));
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<ScheduleInstancePagingVO> scheduleInstancePageBy(ScheduleInstancePagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scheduleInstancePagingVO).from((EntityPath)scheduleInstanceDO)).leftJoin((EntityPath)scheduleConfigDO)).on((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.id.eq(ScheduleInstanceRepoProc.scheduleInstanceDO.masId));
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, scheduleInstanceDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(ScheduleInstanceQueryParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(ScheduleInstanceRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getInstanceStatus())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.instanceStatus.eq((Object)query.getInstanceStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getErrorMessage())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getErrorMessage());
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.errorMessage.like(likeStr));
        }
        if (ObjectUtil.isNotNull((Object)query.getStartTime())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.startTime.goe((Comparable)query.getStartTime()));
        }
        if (ObjectUtil.isNotNull((Object)query.getEndTime())) {
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.endTime.loe((Comparable)query.getEndTime()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getRemark());
            predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.remark.like(likeStr));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScheduleInstanceRespVO> scheduleInstanceByParam(ScheduleInstanceQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scheduleInstanceVO).from((EntityPath)scheduleInstanceDO)).leftJoin((EntityPath)scheduleConfigDO)).on((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.id.eq(ScheduleInstanceRepoProc.scheduleInstanceDO.masId));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long update(ScheduleInstanceSaveParamVO saveParam) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleInstanceDO).set((Path)ScheduleInstanceRepoProc.scheduleInstanceDO.instanceStatus, (Object)saveParam.getInstanceStatus()).set(ScheduleInstanceRepoProc.scheduleInstanceDO.endTime, (Object)saveParam.getEndTime()).set((Path)ScheduleInstanceRepoProc.scheduleInstanceDO.errorMessage, (Object)saveParam.getErrorMessage()).where(new Predicate[]{ScheduleInstanceRepoProc.scheduleInstanceDO.id.eq((Object)saveParam.getId())});
        if (StrUtil.isNotBlank((CharSequence)saveParam.getRemark())) {
            update.set((Path)ScheduleInstanceRepoProc.scheduleInstanceDO.remark, (Object)saveParam.getRemark());
        }
        return update.execute();
    }

    public ScheduleInstanceRespVO findById(Long instanceId) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.deleteFlag.eq((Object)0));
        predicates.add(ScheduleInstanceRepoProc.scheduleInstanceDO.id.eq((Object)instanceId));
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.scheduleInstanceVO).from((EntityPath)scheduleInstanceDO)).leftJoin((EntityPath)scheduleConfigDO)).on((Predicate)ScheduleInstanceRepoProc.scheduleConfigDO.id.eq(ScheduleInstanceRepoProc.scheduleInstanceDO.masId));
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return (ScheduleInstanceRespVO)jpaQuery.fetchOne();
    }

    public ScheduleInstanceRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.scheduleInstancePagingVO = Projections.bean(ScheduleInstancePagingVO.class, (Expression[])new Expression[]{ScheduleInstanceRepoProc.scheduleInstanceDO.id, ScheduleInstanceRepoProc.scheduleInstanceDO.masId, ScheduleInstanceRepoProc.scheduleConfigDO.taskCode, ScheduleInstanceRepoProc.scheduleConfigDO.taskName, ScheduleInstanceRepoProc.scheduleInstanceDO.instanceStatus, ScheduleInstanceRepoProc.scheduleInstanceDO.errorMessage, ScheduleInstanceRepoProc.scheduleInstanceDO.startTime, ScheduleInstanceRepoProc.scheduleInstanceDO.endTime, ScheduleInstanceRepoProc.scheduleInstanceDO.remark, ScheduleInstanceRepoProc.scheduleInstanceDO.createUserId, ScheduleInstanceRepoProc.scheduleInstanceDO.creator, ScheduleInstanceRepoProc.scheduleInstanceDO.createTime, ScheduleInstanceRepoProc.scheduleInstanceDO.modifyUserId, ScheduleInstanceRepoProc.scheduleInstanceDO.updater, ScheduleInstanceRepoProc.scheduleInstanceDO.modifyTime, ScheduleInstanceRepoProc.scheduleInstanceDO.deleteFlag});
        this.scheduleInstanceVO = Projections.bean(ScheduleInstanceRespVO.class, (Expression[])new Expression[]{ScheduleInstanceRepoProc.scheduleInstanceDO.id, ScheduleInstanceRepoProc.scheduleInstanceDO.masId, ScheduleInstanceRepoProc.scheduleConfigDO.taskCode, ScheduleInstanceRepoProc.scheduleConfigDO.taskName, ScheduleInstanceRepoProc.scheduleInstanceDO.instanceStatus, ScheduleInstanceRepoProc.scheduleInstanceDO.errorMessage, ScheduleInstanceRepoProc.scheduleInstanceDO.startTime, ScheduleInstanceRepoProc.scheduleInstanceDO.endTime, ScheduleInstanceRepoProc.scheduleInstanceDO.remark, ScheduleInstanceRepoProc.scheduleInstanceDO.createUserId, ScheduleInstanceRepoProc.scheduleInstanceDO.creator, ScheduleInstanceRepoProc.scheduleInstanceDO.createTime, ScheduleInstanceRepoProc.scheduleInstanceDO.modifyUserId, ScheduleInstanceRepoProc.scheduleInstanceDO.updater, ScheduleInstanceRepoProc.scheduleInstanceDO.modifyTime, ScheduleInstanceRepoProc.scheduleInstanceDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

