/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.service;

import com.elitesland.cbpl.scheduling.convert.ScheduleInstanceConvert;
import com.elitesland.cbpl.scheduling.domain.InstanceStatus;
import com.elitesland.cbpl.scheduling.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.service.ScheduleInstanceService;
import com.elitesland.cbpl.scheduling.spi.ScheduleCompleteProvider;
import com.elitesland.cbpl.scheduling.vo.param.ScheduleInstanceSaveParamVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceDetailVO;
import com.elitesland.cbpl.scheduling.vo.resp.ScheduleInstanceRespVO;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.elitesland.cbpl.tool.tenant.TenantClientSpi;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import java.time.LocalDateTime;
import javax.annotation.Resource;
import org.apache.skywalking.apm.toolkit.trace.RunnableWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleExecuteHandler {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleExecuteHandler.class);
    @Resource
    private ScheduleInstanceService scheduleInstanceService;
    @Autowired(required=false)
    private ScheduleCompleteProvider scheduleCompleteProvider;
    @Autowired(required=false)
    private TenantClientSpi tenantClientSpi;

    public Runnable runAuto(ScheduledTask task) {
        String tenantCode = TenantSpiUtil.currentTenantCode();
        Runnable executor = () -> this.runImmediately(task, "\u81ea\u52a8\u6267\u884c");
        if (this.tenantClientSpi == null) {
            return RunnableWrapper.of((Runnable)executor);
        }
        return RunnableWrapper.of(() -> this.tenantClientSpi.byTenantDirectly(executor, tenantCode));
    }

    public void runImmediately(ScheduledTask task) {
        this.runImmediately(task, "\u624b\u52a8\u6267\u884c");
    }

    public void runImmediately(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO instance = this.instanceLog(task, runType);
        this.updateInstanceStatus(instance, task.getTriggerTask().getRunnable());
    }

    private ScheduleInstanceSaveParamVO instanceLog(ScheduledTask task, String runType) {
        ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
        saveParam.setMasId(task.getTaskId());
        saveParam.setTaskCode(task.getTaskCode());
        saveParam.setTaskName(task.getTaskName());
        saveParam.setStartTime(LocalDateTime.now());
        saveParam.setInstanceStatus(InstanceStatus.RUNNING.getCode());
        saveParam.setRemark(runType);
        Long instanceId = this.scheduleInstanceService.save(saveParam);
        saveParam.setId(instanceId);
        return saveParam;
    }

    private void updateInstanceStatus(ScheduleInstanceSaveParamVO instance, Runnable runnable) {
        try {
            if (this.scheduleCompleteProvider != null) {
                ScheduleInstanceRespVO response = ScheduleInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.scheduleCompleteProvider.start(response);
            }
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute complete start error.", (Throwable)e);
        }
        Exception throwable = null;
        try {
            instance.setInstanceStatus(InstanceStatus.COMPLETE.getCode());
            runnable.run();
        }
        catch (Exception e) {
            throwable = e;
            instance.setInstanceStatus(InstanceStatus.INTERRUPT.getCode());
            instance.setErrorMessage(ExceptionUtils.formatException((Throwable)e, (int)255));
        }
        instance.setEndTime(LocalDateTime.now());
        this.scheduleInstanceService.update(instance);
        try {
            if (this.scheduleCompleteProvider != null) {
                ScheduleInstanceRespVO response = ScheduleInstanceConvert.INSTANCE.saveParamToVO(instance);
                this.scheduleCompleteProvider.whenComplete(response, throwable);
            }
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] execute complete callback error.", (Throwable)e);
        }
    }

    public void stopImmediately(Long instanceId, boolean stopTag) {
        try {
            ScheduleInstanceDetailVO instance = this.scheduleInstanceService.scheduleInstanceById(instanceId);
            ScheduleInstanceSaveParamVO saveParam = new ScheduleInstanceSaveParamVO();
            saveParam.setId(instanceId);
            saveParam.setEndTime(LocalDateTime.now());
            saveParam.setInstanceStatus(InstanceStatus.STOP.getCode());
            saveParam.setRemark(instance.getRemark() + " \u624b\u52a8\u7ec8\u6b62\uff0c\u662f\u5426\u7ec8\u6b62\u6210\u529f\uff1a" + stopTag + "\uff1b");
            this.scheduleInstanceService.update(saveParam);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SCHEDULE] stop immediately unexpected error.", (Throwable)e);
        }
    }
}

