create table sys_schedule_config (
    id                 bigint        not null comment '主键' primary key,
    task_name           varchar(200)      null comment '定时任务名称',
    task_code           varchar(200)      null comment '定时任务编码',
    class_name         varchar(200)      null comment '类名',
    method             varchar(250)      null comment '方法名',
    cron               varchar(200)      null comment '定时任务表达式',
    active_flag        varchar(2)        null comment '启用标记',
    tenant_id          bigint default -1 null comment '所属租户ID',
    belong_org_id      bigint            null comment '所属组织ID',
    tenant_org_id      bigint            null comment '租户组织ID',
    remark             varchar(255)      null comment '备注',
    create_user_id     bigint            null comment '记录创建者ID',
    creator            varchar(255)      null comment '记录创建者',
    create_time        datetime(6)       null comment '记录创建时间',
    modify_user_id     bigint            null comment '记录最后更新者ID',
    updater            varchar(255)      null comment '记录最后更新者',
    modify_time        datetime(6)       null comment '记录最后更新时间',
    delete_flag        int    default 0  null comment '删除标记',
    audit_data_version int               null comment '锁版本',
    sec_bu_id          bigint            null comment '数据归属组织ID',
    sec_user_id        bigint            null comment '数据归属雇员ID',
    sec_ou_id          bigint            null comment '数据归属公司ID'
) comment='定时任务配置表';

create table sys_schedule_instance (
    id                 bigint        not null comment '主键' primary key,
    mas_id             bigint            null comment '任务ID',
    instance_status    varchar(20)       null comment '日志行状态',
    error_message      varchar(255)      null comment '错误日志',
    start_time         datetime(6)       null comment '开始时间',
    end_time           datetime(6)       null comment '结束时间',
    tenant_id          bigint default -1 null comment '所属租户ID',
    belong_org_id      bigint            null comment '所属组织ID',
    tenant_org_id      bigint            null comment '租户组织ID',
    remark             varchar(255)      null comment '备注',
    create_user_id     bigint            null comment '记录创建者ID',
    creator            varchar(255)      null comment '记录创建者',
    create_time        datetime(6)       null comment '记录创建时间',
    modify_user_id     bigint            null comment '记录最后更新者ID',
    updater            varchar(255)      null comment '记录最后更新者',
    modify_time        datetime(6)       null comment '记录最后更新时间',
    delete_flag        int    default 0  null comment '删除标记',
    audit_data_version int               null comment '锁版本',
    sec_bu_id          bigint            null comment '数据归属组织ID',
    sec_user_id        bigint            null comment '数据归属雇员ID',
    sec_ou_id          bigint            null comment '数据归属公司ID'
) comment='定时任务实例表';