package com.elitesland.cbpl.scheduling.config;

import lombok.Data;
import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ConfigurationProperties(prefix = SCHEDULE_CONFIG_PREFIX)
public class SchedulingProperties implements InitializingBean {

    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.schedule";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 核心线程数，默认4
     */
    private int corePoolSize = 4;

    /**
     * 最大线程数，默认cpu核数
     */
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;

    /**
     * 队列容量，默认1024
     */
    private int queueCapacity = 1024;

    /**
     * <li>拒绝策略：默认`AbortPolicy`</li>
     * <li>see: {@link RejectedTypeEnum}</li>
     */
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();

    public static boolean SCHEDULE_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = enabled;
    }
}
