package com.elitesland.cbpl.scheduling.data.convert;

import com.elitesland.cbpl.rosefinch.data.vo.param.RosefinchConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.entity.ScheduleConfigDO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.tool.db.BaseMapperConfig;
import org.mapstruct.Mapper;
import org.mapstruct.MappingTarget;
import org.mapstruct.factory.Mappers;

import java.util.List;

/**
 * 实体对象转换类
 *
 * @author eric.hao
 * @since 2023/09/06
 */
@Mapper(config = BaseMapperConfig.class)
public interface ScheduleConfigConvert {

    ScheduleConfigConvert INSTANCE = Mappers.getMapper(ScheduleConfigConvert.class);

    /**
     * DO => PageVO
     */
    List<ScheduleConfigPagingVO> doToPageVO(List<ScheduleConfigDO> scheduleConfigDO);

    ScheduleConfigPagingVO doToPageVO(ScheduleConfigDO scheduleConfigDO);

    /**
     * SaveParam => DO
     */
    ScheduleConfigDO saveParamToDO(ScheduleConfigSaveParamVO saveParam);

    /**
     * SaveParam Merge-Into DO
     */
    void saveParamMergeToDO(ScheduleConfigSaveParamVO saveParam, @MappingTarget ScheduleConfigDO scheduleConfigDO);

    /**
     * DO => DetailVO
     */
    ScheduleConfigDetailVO doToDetailVO(ScheduleConfigDO scheduleConfigDO);

    /**
     * saveParam => RosefinchParam
     */
    RosefinchConfigSaveParamVO saveParamToRosefinch(ScheduleConfigSaveParamVO saveParam);
}
