package com.elitesland.cbpl.scheduling.data.service;

import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigSaveParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.tool.db.PagingVO;

import java.util.List;
import java.util.Set;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
public interface ScheduleConfigService {

    /**
     * 分页查询
     *
     * @param query 分页参数
     * @return 分页结果
     */
    PagingVO<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query);

    /**
     * 不分页查询
     *
     * @param query 查询参数
     * @return 列表数据
     */
    List<ScheduledTask> scheduleConfigByParam(ScheduleConfigQueryParamVO query);

    /**
     * 明细查询
     *
     * @param id 业务单据ID
     * @return 明细数据
     */
    ScheduleConfigDetailVO scheduleConfigById(Long id);

    /**
     * 新增或修改
     *
     * @param saveParam 保存参数
     * @return 业务单据ID
     */
    Long save(ScheduleConfigSaveParamVO saveParam);

    /**
     * 启用
     *
     * @param id 业务单据ID
     */
    void active(Long id);

    /**
     * 禁用
     *
     * @param id 业务单据ID
     */
    void inactive(Long id);

    /**
     * 批量物理删除
     *
     * @param ids 业务单据ID
     * @return 删除成功的数量
     */
    void delete(List<Long> ids);

    /**
     * 立即执行一次
     *
     * @param taskId 任务主键id
     * @return
     */
    void execute(Long taskId);

    /**
     * CRON表达式预览：列举当前时间后，20个匹配表达式的日期
     *
     * @param taskId 任务主键id
     * @return 实例列表
     */
    List<String> preview(Long taskId);

    /**
     * 所有任务列表
     */
    Set<String> taskCodes();

    /**
     * 终止任务
     */
    boolean stopImmediately(String taskCode);
}
