package com.elitesland.cbpl.scheduling.registrar.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.spi.RosefinchStatusListener;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.List;

import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_BUSINESS_TAG;
import static com.elitesland.cbpl.scheduling.constant.ScheduleTag.SCHEDULE_DELETION_TAG;

/**
 * @author eric.hao
 * @since 2024/08/13
 */
@Slf4j
@RequiredArgsConstructor
public class ScheduleStatusService implements RosefinchStatusListener {

    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required = false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    @Override
    public boolean supports(RosefinchConfigDetailVO rosefinchCfg) {
        List<String> status = ListUtil.of(SCHEDULE_BUSINESS_TAG, SCHEDULE_DELETION_TAG);
        return status.contains(rosefinchCfg.getTaskTag());
    }

    @Override
    public void active(RosefinchConfigDetailVO rosefinchCfg) {
        var schedule = scheduleConfigRepoProc.findByRosefinchId(rosefinchCfg.getId());
        if (ObjectUtil.isNotNull(schedule)) {
            resetTriggerTask(SchedulingUtil.builder(schedule));
        }
    }

    @Override
    public void inactive(RosefinchConfigDetailVO rosefinchCfg) {
        var schedule = scheduleConfigRepoProc.findByRosefinchId(rosefinchCfg.getId());
        if (ObjectUtil.isNotNull(schedule)) {
            cancelTriggerTask(SchedulingUtil.builder(schedule));
        }
    }

    /**
     * 重置定时任务
     */
    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull(schedulingRegistrar)) {
            schedulingRegistrar.resetTriggerTask(task);
        }
    }

    /**
     * 取消定时任务 - 执行中的任务不强制终止
     */
    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull(schedulingRegistrar)) {
            schedulingRegistrar.cancelTriggerTask(task);
        }
    }
}
