/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import org.dromara.dynamictp.common.constant.DynamicTpConst;
import org.dromara.dynamictp.common.em.RejectedTypeEnum;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix="cbpl.schedule")
public class SchedulingProperties
implements InitializingBean {
    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.schedule";
    private boolean enabled;
    private int corePoolSize = 4;
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;
    private int queueCapacity = 1024;
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();
    public static boolean SCHEDULE_ENABLED;

    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public String getRejectPolicy() {
        return this.rejectPolicy;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setRejectPolicy(String rejectPolicy) {
        this.rejectPolicy = rejectPolicy;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchedulingProperties)) {
            return false;
        }
        SchedulingProperties other = (SchedulingProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getCorePoolSize() != other.getCorePoolSize()) {
            return false;
        }
        if (this.getMaximumPoolSize() != other.getMaximumPoolSize()) {
            return false;
        }
        if (this.getQueueCapacity() != other.getQueueCapacity()) {
            return false;
        }
        String this$rejectPolicy = this.getRejectPolicy();
        String other$rejectPolicy = other.getRejectPolicy();
        return !(this$rejectPolicy == null ? other$rejectPolicy != null : !this$rejectPolicy.equals(other$rejectPolicy));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchedulingProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getCorePoolSize();
        result = result * 59 + this.getMaximumPoolSize();
        result = result * 59 + this.getQueueCapacity();
        String $rejectPolicy = this.getRejectPolicy();
        result = result * 59 + ($rejectPolicy == null ? 43 : $rejectPolicy.hashCode());
        return result;
    }

    public String toString() {
        return "SchedulingProperties(enabled=" + this.isEnabled() + ", corePoolSize=" + this.getCorePoolSize() + ", maximumPoolSize=" + this.getMaximumPoolSize() + ", queueCapacity=" + this.getQueueCapacity() + ", rejectPolicy=" + this.getRejectPolicy() + ")";
    }
}

