package com.elitesland.cbpl.scheduling.config;

import com.dtp.common.constant.DynamicTpConst;
import com.dtp.common.em.RejectedTypeEnum;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.scheduling.config.SchedulingProperties.SCHEDULE_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@ConfigurationProperties(prefix = SCHEDULE_CONFIG_PREFIX)
public class SchedulingProperties implements InitializingBean {

    public static final String SCHEDULE_CONFIG_PREFIX = "cbpl.schedule";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    /**
     * 核心线程数，默认4
     */
    private int corePoolSize = 4;

    /**
     * 最大线程数，默认cpu核数
     */
    private int maximumPoolSize = DynamicTpConst.AVAILABLE_PROCESSORS;

    /**
     * 队列容量，默认1024
     */
    private int queueCapacity = 1024;

    /**
     * <li>拒绝策略：默认`AbortPolicy`</li>
     * <li>see: {@link RejectedTypeEnum}</li>
     */
    private String rejectPolicy = RejectedTypeEnum.ABORT_POLICY.getName();

    /**
     * 持有锁的最长时间（单位秒），默认600
     * <p>防止宕机死锁</p>
     */
    private int lockAtMostFor = 600;

    /**
     * 持有锁的最短时间（单位秒），默认10
     * <p>避免各个服务器的微小时钟差异，重复调用</p>
     */
    private int lockAtLeastFor = 10;

    public static boolean SCHEDULE_ENABLED;
    public static int SCHEDULE_LOCK_AT_MOST_FOR;
    public static int SCHEDULE_LOCK_AT_LEAST_FOR;

    @Override
    public void afterPropertiesSet() throws Exception {
        SCHEDULE_ENABLED = enabled;
        SCHEDULE_LOCK_AT_MOST_FOR = lockAtMostFor;
        SCHEDULE_LOCK_AT_LEAST_FOR = lockAtLeastFor;
    }
}
