package com.elitesland.cbpl.scheduling.registrar.domain;

import com.elitesland.cbpl.rosefinch.client.constant.RosefinchType;
import com.elitesland.cbpl.rosefinch.client.queue.producer.message.TaskInfo;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;
import org.springframework.scheduling.support.CronTrigger;

/**
 * @author eric.hao
 * @since 2023/09/06
 */
@Data
@Builder
@ApiModel("任务管理")
public class ScheduledTask {

    @ApiModelProperty("任务中心关联ID")
    private Long rosefinchId;

    @ApiModelProperty(value = "任务名称")
    private String taskName;

    @ApiModelProperty(value = "任务编码")
    private String taskCode;

    @ApiModelProperty(value = "类名")
    private String className;

    @ApiModelProperty(value = "方法名")
    private String methodName;

    @ApiModelProperty(value = "方法参数")
    private String methodArgs;

    @ApiModelProperty(value = "定时任务表达式")
    private String cron;

    public TaskInfo info() {
        TaskInfo taskInfo = new TaskInfo();
        taskInfo.setTaskId(rosefinchId);
        taskInfo.setTaskName(taskName);
        taskInfo.setTaskCode(taskCode);
        taskInfo.setTaskType(RosefinchType.REFLECT.getCode());
        taskInfo.setClassName(className);
        taskInfo.setMethod(methodName);
        taskInfo.setMethodArgs(methodArgs);
        return taskInfo;
    }

    public CronTrigger getTrigger() {
        return new CronTrigger(cron);
    }

}
