/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.config;

import com.dtp.core.thread.NamedThreadFactory;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchConfigService;
import com.elitesland.cbpl.rosefinch.data.service.RosefinchInstanceService;
import com.elitesland.cbpl.rosefinch.registrar.task.InstanceDeletionTask;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.ScheduleInitialize;
import com.elitesland.cbpl.scheduling.registrar.service.ScheduleStatusService;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.provider.redis.spring.RedisLockProvider;
import net.javacrumbs.shedlock.spring.annotation.EnableSchedulerLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.scheduling.annotation.EnableScheduling;

@EnableScheduling
@Configuration
@EnableConfigurationProperties(value={SchedulingProperties.class})
@EnableSchedulerLock(defaultLockAtMostFor="PT2M")
@ConditionalOnProperty(prefix="cbpl.schedule", name={"enabled"}, havingValue="true")
public class SchedulingAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(SchedulingAutoConfiguration.class);

    @Bean
    @ConditionalOnClass
    public LockProvider lockProvider(RedisTemplate<?, ?> redisTemplate) {
        return new RedisLockProvider(Objects.requireNonNull(redisTemplate.getConnectionFactory()));
    }

    @Bean
    public DefaultSchedulingRegistrar defaultSchedulingRegistrar() {
        logger.info("[SCHEDULE] Scheduling enabled.");
        return new DefaultSchedulingRegistrar();
    }

    @Bean
    public ScheduleInitialize scheduleInitialize(DefaultSchedulingRegistrar schedulingRegistrar) {
        ScheduleInitialize schedule = new ScheduleInitialize(schedulingRegistrar);
        logger.info("[SCHEDULE] Initialize finished.");
        return schedule;
    }

    @Bean
    @ConditionalOnClass(value={RosefinchConfigService.class, RosefinchInstanceService.class})
    public InstanceDeletionTask instanceDeletionTask(RosefinchConfigService rosefinchConfigService, RosefinchInstanceService rosefinchInstanceService) {
        return new InstanceDeletionTask(rosefinchConfigService, rosefinchInstanceService);
    }

    @Bean(value={"phoenixScheduleTp"})
    public ScheduledExecutorService phoenixScheduleTp(SchedulingProperties properties) {
        return new ScheduledThreadPoolExecutor(properties.getCorePoolSize(), (ThreadFactory)new NamedThreadFactory("phoenixScheduleTp"), new ThreadPoolExecutor.AbortPolicy());
    }

    @Bean
    @ConditionalOnClass(value={ScheduleConfigRepoProc.class})
    public ScheduleStatusService scheduleStatusService(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        return new ScheduleStatusService(scheduleConfigRepoProc);
    }
}

