/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.data.repo;

import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.rosefinch.data.entity.QRosefinchConfigDO;
import com.elitesland.cbpl.scheduling.data.entity.QScheduleConfigDO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigPagingParamVO;
import com.elitesland.cbpl.scheduling.data.vo.param.ScheduleConfigQueryParamVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigPagingVO;
import com.elitesland.cbpl.tool.db.SqlUtil;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.QBean;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Component;

@Component
public class ScheduleConfigRepoProc {
    private final JPAQueryFactory jpaQueryFactory;
    private static final QRosefinchConfigDO rosefinchConfigDO = QRosefinchConfigDO.rosefinchConfigDO;
    private static final QScheduleConfigDO scheduleConfigDO = QScheduleConfigDO.scheduleConfigDO;
    private final QBean<ScheduleConfigPagingVO> pagingVO;
    private final QBean<ScheduleConfigDetailVO> detailVO;

    private Predicate pagingWhere(ScheduleConfigPagingParamVO query) {
        String likeStr;
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (ObjectUtil.isNotNull((Object)query.getTaskCodeName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskCodeName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCodeName()).or((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr)));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            likeStr = SqlUtil.toSqlLikeString((String)query.getTaskName());
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.like(likeStr));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getClassName())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.className.eq((Object)query.getClassName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getMethod())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.method.eq((Object)query.getMethod()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getCron())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.cron.eq((Object)query.getCron()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.status.eq((Object)query.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getRemark())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.remark.eq((Object)query.getRemark()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskTag())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.taskTag.eq((Object)query.getTaskTag()));
        } else {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.taskTag.eq((Object)"ST_BUSINESS").or((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.taskCode.isNull()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public long scheduleConfigCountBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(ScheduleConfigRepoProc.scheduleConfigDO.id).from((EntityPath)scheduleConfigDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.id.eq(ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId));
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch().size();
    }

    public List<ScheduleConfigPagingVO> scheduleConfigPageBy(ScheduleConfigPagingParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.pagingVO).from((EntityPath)scheduleConfigDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.id.eq(ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId));
        query.setPaging(jpaQuery);
        query.fillOrders(jpaQuery, scheduleConfigDO);
        jpaQuery.where(this.pagingWhere(query));
        return jpaQuery.fetch();
    }

    private Predicate where(ScheduleConfigQueryParamVO query) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag.eq((Object)0));
        if (StrUtil.isNotBlank((CharSequence)query.getTaskName())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskName.eq((Object)query.getTaskName()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskCode())) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)query.getTaskCode()));
        }
        if (ObjectUtil.isNotNull((Object)query.getStatus())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.status.eq((Object)query.getStatus()));
        }
        if (StrUtil.isNotBlank((CharSequence)query.getTaskTag())) {
            predicates.add(ScheduleConfigRepoProc.rosefinchConfigDO.taskTag.eq((Object)query.getTaskTag()));
        }
        return ExpressionUtils.allOf(predicates);
    }

    public List<ScheduleConfigDetailVO> scheduleConfigByParam(ScheduleConfigQueryParamVO query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailVO).from((EntityPath)scheduleConfigDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.id.eq(ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId));
        jpaQuery.where(this.where(query));
        return jpaQuery.fetch();
    }

    public long updateDeleteFlag(List<Long> ids) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)scheduleConfigDO).set(ScheduleConfigRepoProc.scheduleConfigDO.deleteFlag, (Object)1).where(new Predicate[]{ScheduleConfigRepoProc.scheduleConfigDO.id.in(ids)});
        return update.execute();
    }

    public boolean existsByCode(Long taskId, String taskCode) {
        ArrayList<BooleanExpression> predicates = new ArrayList<BooleanExpression>();
        predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.taskCode.eq((Object)taskCode));
        if (ObjectUtil.isNotNull((Object)taskId)) {
            predicates.add(ScheduleConfigRepoProc.scheduleConfigDO.id.ne((Object)taskId));
        }
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select(ScheduleConfigRepoProc.scheduleConfigDO.id).from((EntityPath)scheduleConfigDO);
        jpaQuery.where(ExpressionUtils.allOf(predicates));
        return !jpaQuery.fetch().isEmpty();
    }

    public ScheduleConfigDetailVO findById(Long taskId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailVO).from((EntityPath)scheduleConfigDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.id.eq(ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId));
        jpaQuery.where((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.id.eq((Object)taskId));
        return (ScheduleConfigDetailVO)jpaQuery.fetchOne();
    }

    public ScheduleConfigDetailVO findByRosefinchId(Long rosefinchId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(this.detailVO).from((EntityPath)scheduleConfigDO)).leftJoin((EntityPath)rosefinchConfigDO)).on((Predicate)ScheduleConfigRepoProc.rosefinchConfigDO.id.eq(ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId));
        jpaQuery.where((Predicate)ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId.eq((Object)rosefinchId));
        return (ScheduleConfigDetailVO)jpaQuery.fetchOne();
    }

    public ScheduleConfigRepoProc(JPAQueryFactory jpaQueryFactory) {
        this.pagingVO = Projections.bean(ScheduleConfigPagingVO.class, (Expression[])new Expression[]{ScheduleConfigRepoProc.scheduleConfigDO.id, ScheduleConfigRepoProc.scheduleConfigDO.taskName, ScheduleConfigRepoProc.scheduleConfigDO.taskCode, ScheduleConfigRepoProc.scheduleConfigDO.cron, ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId, ScheduleConfigRepoProc.rosefinchConfigDO.className, ScheduleConfigRepoProc.rosefinchConfigDO.method, ScheduleConfigRepoProc.rosefinchConfigDO.methodArgs, ScheduleConfigRepoProc.rosefinchConfigDO.taskTag, ScheduleConfigRepoProc.rosefinchConfigDO.status, ScheduleConfigRepoProc.rosefinchConfigDO.deletionStrategy, ScheduleConfigRepoProc.rosefinchConfigDO.tenantId, ScheduleConfigRepoProc.rosefinchConfigDO.remark, ScheduleConfigRepoProc.rosefinchConfigDO.createUserId, ScheduleConfigRepoProc.rosefinchConfigDO.creator, ScheduleConfigRepoProc.rosefinchConfigDO.createTime, ScheduleConfigRepoProc.rosefinchConfigDO.modifyUserId, ScheduleConfigRepoProc.rosefinchConfigDO.updater, ScheduleConfigRepoProc.rosefinchConfigDO.modifyTime, ScheduleConfigRepoProc.rosefinchConfigDO.deleteFlag});
        this.detailVO = Projections.bean(ScheduleConfigDetailVO.class, (Expression[])new Expression[]{ScheduleConfigRepoProc.scheduleConfigDO.id, ScheduleConfigRepoProc.scheduleConfigDO.taskName, ScheduleConfigRepoProc.scheduleConfigDO.taskCode, ScheduleConfigRepoProc.scheduleConfigDO.cron, ScheduleConfigRepoProc.scheduleConfigDO.rosefinchId, ScheduleConfigRepoProc.rosefinchConfigDO.className, ScheduleConfigRepoProc.rosefinchConfigDO.method, ScheduleConfigRepoProc.rosefinchConfigDO.methodArgs, ScheduleConfigRepoProc.rosefinchConfigDO.taskTag, ScheduleConfigRepoProc.rosefinchConfigDO.status, ScheduleConfigRepoProc.rosefinchConfigDO.deletionStrategy, ScheduleConfigRepoProc.rosefinchConfigDO.tenantId, ScheduleConfigRepoProc.rosefinchConfigDO.remark, ScheduleConfigRepoProc.rosefinchConfigDO.createUserId, ScheduleConfigRepoProc.rosefinchConfigDO.creator, ScheduleConfigRepoProc.rosefinchConfigDO.createTime, ScheduleConfigRepoProc.rosefinchConfigDO.modifyUserId, ScheduleConfigRepoProc.rosefinchConfigDO.updater, ScheduleConfigRepoProc.rosefinchConfigDO.modifyTime, ScheduleConfigRepoProc.rosefinchConfigDO.deleteFlag});
        this.jpaQueryFactory = jpaQueryFactory;
    }
}

