/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.registrar.service;

import cn.hutool.core.collection.ListUtil;
import cn.hutool.core.util.ObjectUtil;
import com.elitesland.cbpl.rosefinch.data.vo.resp.RosefinchConfigDetailVO;
import com.elitesland.cbpl.rosefinch.spi.RosefinchStatusListener;
import com.elitesland.cbpl.scheduling.data.repo.ScheduleConfigRepoProc;
import com.elitesland.cbpl.scheduling.data.vo.resp.ScheduleConfigDetailVO;
import com.elitesland.cbpl.scheduling.registrar.DefaultSchedulingRegistrar;
import com.elitesland.cbpl.scheduling.registrar.domain.ScheduledTask;
import com.elitesland.cbpl.scheduling.util.SchedulingUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ScheduleStatusService
implements RosefinchStatusListener {
    private static final Logger logger = LoggerFactory.getLogger(ScheduleStatusService.class);
    private final ScheduleConfigRepoProc scheduleConfigRepoProc;
    @Autowired(required=false)
    private DefaultSchedulingRegistrar schedulingRegistrar;

    public boolean supports(RosefinchConfigDetailVO rosefinchCfg) {
        List status = ListUtil.of((Object[])new String[]{"ST_BUSINESS", "ST_DELETION"});
        return status.contains(rosefinchCfg.getTaskTag());
    }

    public void active(RosefinchConfigDetailVO rosefinchCfg) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigRepoProc.findByRosefinchId(rosefinchCfg.getId());
        if (ObjectUtil.isNotNull((Object)schedule)) {
            this.resetTriggerTask(SchedulingUtil.builder(schedule));
        }
    }

    public void inactive(RosefinchConfigDetailVO rosefinchCfg) {
        ScheduleConfigDetailVO schedule = this.scheduleConfigRepoProc.findByRosefinchId(rosefinchCfg.getId());
        if (ObjectUtil.isNotNull((Object)schedule)) {
            this.cancelTriggerTask(SchedulingUtil.builder(schedule));
        }
    }

    private void resetTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.resetTriggerTask(task);
        }
    }

    private void cancelTriggerTask(ScheduledTask task) {
        if (ObjectUtil.isNotNull((Object)this.schedulingRegistrar)) {
            this.schedulingRegistrar.cancelTriggerTask(task);
        }
    }

    public ScheduleStatusService(ScheduleConfigRepoProc scheduleConfigRepoProc) {
        this.scheduleConfigRepoProc = scheduleConfigRepoProc;
    }
}

