/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.scheduling.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.scheduling.config.SchedulingProperties;
import java.time.Duration;
import java.time.Instant;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import net.javacrumbs.shedlock.core.DefaultLockingTaskExecutor;
import net.javacrumbs.shedlock.core.LockConfiguration;
import net.javacrumbs.shedlock.core.LockProvider;
import net.javacrumbs.shedlock.core.LockingTaskExecutor;

public class SchedulingLock {
    private static LockProvider lockProvider;
    private static LockingTaskExecutor lockingTaskExecutor;

    private static LockProvider getLockProvider() {
        if (lockProvider == null) {
            lockProvider = (LockProvider)SpringUtil.getBean(LockProvider.class);
        }
        return lockProvider;
    }

    private static LockingTaskExecutor getTaskExecutor() {
        if (lockingTaskExecutor == null) {
            lockingTaskExecutor = new DefaultLockingTaskExecutor(SchedulingLock.getLockProvider());
        }
        return lockingTaskExecutor;
    }

    public static void schedulerWithLock(@NotBlank String taskKey, @NotNull Runnable executor) {
        Duration lockAtMostFor = Duration.ofSeconds(SchedulingProperties.SCHEDULE_LOCK_AT_MOST_FOR);
        Duration lockAtLeastFor = Duration.ofSeconds(SchedulingProperties.SCHEDULE_LOCK_AT_LEAST_FOR);
        SchedulingLock.getTaskExecutor().executeWithLock(executor, new LockConfiguration(Instant.now(), taskKey, lockAtMostFor, lockAtLeastFor));
    }
}

