package com.elitesland.cbpl.sns.bot.service;

import cn.hutool.core.text.StrPool;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.provider.BotMessageBuilder;
import com.elitesland.cbpl.sns.bot.util.SnsBotUtil;
import com.elitesland.cbpl.tool.core.date.DateUtils;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.apache.skywalking.apm.toolkit.trace.TraceContext;

/**
 * @author eric.hao
 * @since 2023/11/23
 */
@Slf4j
@RequiredArgsConstructor
public class BotMessageDefaultBuilder implements BotMessageBuilder {

    @Override
    public String templateBuilder(BotRequest request) {
        return "> 调用方式：" + request.getSnsMode() + StrPool.LF +
                "> 异常类型：<font color='red'>" + request.getSnsType() + "</font>" + StrPool.LF +
                "> 异常单据类型：" + request.getSnsScene() + StrPool.LF +
                "> 时间：" + DateUtils.nowStr() + StrPool.LF +
                "> TraceID：" + TraceContext.traceId() + StrPool.LF +
                "> 异常信息：" + SnsBotUtil.concat(request.getMessages());
    }
}
