package com.elitesland.cbpl.sns.bot.util;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.text.StrPool;
import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.sns.bot.domain.BotMessage;

import java.util.List;

/**
 * @author eric.hao
 * @since 2023/07/05
 */
public class SnsBotUtil {

    /**
     * 告警消息拼接
     *
     * @param messages 消息列表
     * @return 拼接字符串
     */
    public static String concat(List<BotMessage> messages) {
        if (CollUtil.isEmpty(messages)) {
            return "无";
        }
        return messages.stream().map(msg -> {
            String text = StrPool.LF + "**<font color='red'>" + msg.getBizKey() + "</font>** ";
            return text + StrUtil.join("；", msg.getMessages());
        }).reduce("", String::concat);
    }
}
