/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.bot.config;

import com.elitesland.cbpl.sns.bot.config.SnsBotProperties;
import com.elitesland.cbpl.sns.bot.provider.BotMessageBuilder;
import com.elitesland.cbpl.sns.bot.service.BotMessageDefaultBuilder;
import com.elitesland.cbpl.sns.bot.service.BotSenderService;
import com.github.jaemon.dinger.DingerSender;
import com.github.jaemon.dinger.support.CustomMessage;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={SnsBotProperties.class})
@ConditionalOnProperty(prefix="cbpl.sns.bot", name={"enabled"}, havingValue="true")
public class SnsBotConfig {
    private static final Logger logger = LoggerFactory.getLogger(SnsBotConfig.class);

    @Bean(value={"markDownMessage"})
    @ConditionalOnMissingBean
    public CustomMessage markDownMessage() {
        return (projectId, request) -> {
            StringBuilder text = new StringBuilder("##### " + request.getTitle());
            return MessageFormat.format(" {0}\n{1}", text, request.getContent());
        };
    }

    @Bean
    @ConditionalOnMissingBean
    public BotMessageBuilder botMessageBuilder() {
        return new BotMessageDefaultBuilder();
    }

    @Bean
    public BotSenderService botSender(DingerSender dingerSender, BotMessageBuilder botMessageBuilder) {
        logger.info("[PHOENIX-SNS] load bot message.");
        return new BotSenderService(dingerSender, botMessageBuilder);
    }
}

