package com.elitesland.cbpl.sns.bot.config;

import com.elitesland.cbpl.sns.bot.provider.BotMessageBuilder;
import com.elitesland.cbpl.sns.bot.service.BotMessageDefaultBuilder;
import com.elitesland.cbpl.sns.bot.service.BotSenderService;
import com.github.jaemon.dinger.DingerSender;
import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.support.CustomMessage;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.text.MessageFormat;

import static com.elitesland.cbpl.sns.bot.config.SnsBotProperties.BOT_CONFIG_PREFIX;
import static com.github.jaemon.dinger.constant.DingerConstant.MARKDOWN_MESSAGE;

/**
 * @author eric.hao
 * @since 2023/07/05
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(SnsBotProperties.class)
@ConditionalOnProperty(prefix = BOT_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class SnsBotConfig {

    /**
     * 告警消息的`Markdown`文本格式
     */
    @Bean(MARKDOWN_MESSAGE)
    @ConditionalOnMissingBean
    public CustomMessage markDownMessage() {
        return (String projectId, DingerRequest request) -> {
            StringBuilder text = new StringBuilder("##### " + request.getTitle());
            return MessageFormat.format(" {0}\n{1}", text, request.getContent());
        };
    }

    /**
     * 构建消息模板
     */
    @Bean
    @ConditionalOnMissingBean
    public BotMessageBuilder botMessageBuilder() {
        return new BotMessageDefaultBuilder();
    }

    /**
     * 消息推送实现
     */
    @Bean
    public BotSenderService botSender(DingerSender dingerSender, BotMessageBuilder botMessageBuilder) {
        logger.info("[PHOENIX-SNS] load bot message.");
        return new BotSenderService(dingerSender, botMessageBuilder);
    }
}
