package com.elitesland.cbpl.sns.bot.config;

import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.sns.bot.config.SnsBotProperties.BOT_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2022/09/14
 */
@Data
@ConfigurationProperties(prefix = BOT_CONFIG_PREFIX)
public class SnsBotProperties implements InitializingBean {

    public static final String BOT_CONFIG_PREFIX = "cbpl.sns.bot";

    /**
     * 是否启用：默认关闭
     */
    private boolean enabled;

    public static boolean SNS_BOT_ENABLED;

    @Override
    public void afterPropertiesSet() throws Exception {
        SNS_BOT_ENABLED = enabled;
    }
}
