package com.elitesland.cbpl.sns.bot.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.sns.bot.domain.BotMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.service.BotSenderService;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

import java.util.List;
import java.util.function.Supplier;

import static com.elitesland.cbpl.sns.bot.config.SnsBotProperties.SNS_BOT_ENABLED;

/**
 * 告警机器人 - 工具类
 *
 * @author eric.hao
 * @since 2023/08/17
 */
@Slf4j
@NoArgsConstructor
public class BotSender {

    private static final String ERROR_MESSAGE = "告警机器人未启用";
    private static BotSenderService botSenderService;

    private static BotSenderService getInstance() {
        if (botSenderService == null) {
            botSenderService = SpringUtil.getBean(BotSenderService.class);
        }
        return botSenderService;
    }

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param message     告警信息
     */
    public static void push(Supplier<BotRequest> botSupplier, String message) {
        if (!SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", ERROR_MESSAGE);
            return;
        }
        getInstance().push(botSupplier, message);
    }

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param messages    告警信息
     */
    public static void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        if (!SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", ERROR_MESSAGE);
            return;
        }
        getInstance().push(botSupplier, messages);
    }

    /**
     * 告警推送
     *
     * @param botSupplier 告警事件
     * @param e           异常堆栈
     */
    public static void push(Supplier<BotRequest> botSupplier, Exception e) {
        if (!SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", ERROR_MESSAGE);
            return;
        }
        getInstance().push(botSupplier, e);
    }

    /**
     * 告警推送
     *
     * @param request 告警报文
     */
    public static void push(BotRequest request) {
        if (!SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", ERROR_MESSAGE);
            return;
        }
        getInstance().push(request);
    }
}
