/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.bot.service;

import com.elitesland.cbpl.sns.bot.domain.BotMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.provider.BotMessageBuilder;
import com.elitesland.cbpl.tool.core.bean.BeanUtils;
import com.elitesland.cbpl.tool.core.exceptions.ExceptionUtils;
import com.github.jaemon.dinger.DingerSender;
import com.github.jaemon.dinger.core.entity.DingerRequest;
import com.github.jaemon.dinger.core.entity.enums.MessageSubType;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotSenderService {
    private static final Logger logger = LoggerFactory.getLogger(BotSenderService.class);
    private static final int SEGMENT_LEN = 256;
    private final DingerSender dingerSender;
    private final BotMessageBuilder messageBuilder;

    public void push(Supplier<BotRequest> botSupplier, String message) {
        try {
            BotMessage botMessage = new BotMessage();
            botMessage.setBizKey("");
            botMessage.setMessages(Collections.singletonList(message));
            BotRequest request = botSupplier.get();
            request.setMessages(Collections.singletonList(botMessage));
            this.push(request);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", (Object)ExceptionUtils.formatException((Throwable)e));
        }
    }

    public void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        try {
            BotRequest request = botSupplier.get();
            request.setMessages(messages);
            this.push(request);
        }
        catch (Exception e) {
            logger.error("[PHOENIX-SNS] PUSH BOT ERR: {}", (Object)ExceptionUtils.formatException((Throwable)e));
        }
    }

    public void push(Supplier<BotRequest> botSupplier, Exception e) {
        this.push(botSupplier, ExceptionUtils.stacktraceToOneLineString((Throwable)e, (int)256));
    }

    public void push(BotRequest request) {
        DingerRequest msgReq = DingerRequest.request((String)this.messageBuilder.templateBuilder(request), (String)request.getSnsTitle());
        logger.info("[PHOENIX-SNS] BOT REQUEST: {}", (Object)BeanUtils.toJsonStr((Object)msgReq));
        this.dingerSender.send(MessageSubType.MARKDOWN, msgReq);
    }

    public BotSenderService(DingerSender dingerSender, BotMessageBuilder messageBuilder) {
        this.dingerSender = dingerSender;
        this.messageBuilder = messageBuilder;
    }
}

