/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.cbpl.sns.bot.util;

import cn.hutool.extra.spring.SpringUtil;
import com.elitesland.cbpl.sns.bot.config.SnsBotProperties;
import com.elitesland.cbpl.sns.bot.domain.BotMessage;
import com.elitesland.cbpl.sns.bot.domain.BotRequest;
import com.elitesland.cbpl.sns.bot.service.BotSenderService;
import java.util.List;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BotSender {
    private static final Logger logger = LoggerFactory.getLogger(BotSender.class);
    private static final String ERROR_MESSAGE = "\u544a\u8b66\u673a\u5668\u4eba\u672a\u542f\u7528";
    private static BotSenderService botSenderService;

    private static BotSenderService getInstance() {
        if (botSenderService == null) {
            botSenderService = (BotSenderService)SpringUtil.getBean(BotSenderService.class);
        }
        return botSenderService;
    }

    public static void push(Supplier<BotRequest> botSupplier, String message) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", (Object)ERROR_MESSAGE);
            return;
        }
        BotSender.getInstance().push(botSupplier, message);
    }

    public static void push(Supplier<BotRequest> botSupplier, List<BotMessage> messages) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", (Object)ERROR_MESSAGE);
            return;
        }
        BotSender.getInstance().push(botSupplier, messages);
    }

    public static void push(Supplier<BotRequest> botSupplier, Exception e) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", (Object)ERROR_MESSAGE);
            return;
        }
        BotSender.getInstance().push(botSupplier, e);
    }

    public static void push(BotRequest request) {
        if (!SnsBotProperties.SNS_BOT_ENABLED) {
            logger.warn("[PHOENIX-SNS] {}", (Object)ERROR_MESSAGE);
            return;
        }
        BotSender.getInstance().push(request);
    }
}

