package com.elitesland.cbpl.sns.common.util;

import lombok.extern.slf4j.Slf4j;

import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author eric.hao
 * @since 2024/12/19
 */
@Slf4j
public class SnsUtil {

    /**
     * 从内容中获取跳转链接
     *
     * @param msgContent 模板内容
     * @return 提取后链接
     */
    public static String getTempLinkUrl(String msgContent) {
        Pattern pattern = Pattern.compile("(?<=(href=\\\")).*(?=\\\")");
        Matcher matcher = pattern.matcher(msgContent);
        String url = "";
        if (matcher.find()) {
            url = matcher.group();
            logger.info("[SNS-MSG-TMPL] Link url:{}", url);
        }
        return url;
    }
}
