package com.elitesland.cbpl.sns.inbox.config;

import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import static com.elitesland.cbpl.sns.inbox.config.SnsInboxProperties.INBOX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/12/23
 */
@Slf4j
@Configuration
@EnableConfigurationProperties(SnsInboxProperties.class)
@ConditionalOnProperty(prefix = INBOX_CONFIG_PREFIX, name = "enabled", havingValue = "true")
@RequiredArgsConstructor
public class SnsInboxAutoConfiguration {
}
