package com.elitesland.cbpl.sns.inbox.config;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;

import static com.elitesland.cbpl.sns.inbox.config.SnsInboxProperties.INBOX_CONFIG_PREFIX;

/**
 * @author eric.hao
 * @since 2024/12/23
 */
@Data
@ConfigurationProperties(prefix = INBOX_CONFIG_PREFIX)
public class SnsInboxProperties implements InitializingBean {

    public static final String INBOX_CONFIG_PREFIX = "cbpl.sns.inbox";


    @ApiModelProperty("是否开启：默认关闭")
    private boolean enabled;

    /**
     * 消费方式（仅指定写入形式，系统需支持对应环境）
     */
    @ApiModelProperty("消费方式")
    //@Enumerated(EnumType.STRING)
    private String consumerPipeline = "MONGO";

    /**
     * 日志索引名称
     * consumerPipeline='es'时 => 必填
     */
    @ApiModelProperty("日志索引名称")
    private String esIndexName;

    /**
     * 日志索引生命周期策略名称
     * consumerPipeline='es'时 => 选填
     */
    @ApiModelProperty("索引策略")
    private String esPolicyName;

    /**
     * 数据库名前缀
     * consumerPipeline='mongo'时 => 必填
     */
    @ApiModelProperty("数据库名前缀")
    private String mongoStorePrefix;

    public static boolean SNS_INBOX_ENABLED;
    public static String SNS_INBOX_PIPELINE;

    @Override
    public void afterPropertiesSet() throws Exception {
        SNS_INBOX_ENABLED = enabled;
        SNS_INBOX_PIPELINE = consumerPipeline;
    }
}
