package com.elitesland.cbpl.sns.inbox.controller;

import com.elitesland.cbpl.sns.common.domain.SnsPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.service.InboxService;
import com.elitesland.cbpl.tool.api.domain.HttpResult;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.Set;

/**
 * @author eric.hao
 * @since 2024/12/23
 */
@Api(tags = "消息数据服务")
@RestController
@RequestMapping("/devops")
@RequiredArgsConstructor
public class InboxApi {

    private final InboxService inboxService;

    @ApiOperation(value = "测试推送")
    @GetMapping("/ws/one")
    public HttpResult<?> pushOne(String toUserId, String subject, String content) {
        inboxService.sendInbox(InboxType.INBOX_INFO, Set.of(toUserId), SnsPayload.of(subject, content));
        return HttpResult.ok();
    }
}
