package com.elitesland.cbpl.sns.inbox.domain;

import cn.hutool.core.util.StrUtil;
import com.elitesland.cbpl.tool.mongo.domain.StoreDef;
import com.elitesland.cbpl.tool.tenant.TenantSpiUtil;
import lombok.Getter;

import java.util.stream.Stream;

/**
 * @author eric.hao
 * @since 2024/12/19
 */
@Getter
public enum InboxType implements StoreDef {

    INBOX_STAT("分类统计消息") {
        @Override
        public String getStoreName() {
            return null;
        }
    },
    INBOX_INFO("消息"),
    INBOX_TODO("待办"),
    INBOX_WARN("告警"),

    // 驱逐登录用户
    EVICT_LOGIN("取消登录"),
    EVICT_RESET("用户重置"),
    ;

    /**
     * 消息类型名
     */
    private final String name;

    InboxType(String name) {
        this.name = name;
    }

    /**
     * 消息存储容器名的前缀
     */
    @Override
    public String getPrefix() {
        return TenantSpiUtil.tenantPrefix();
    }

    @Override
    public String getCode() {
        return name();
    }

    public static Stream<InboxType> getStoreTypes() {
        return Stream.of(InboxType.values())
                .filter(v -> StrUtil.isNotBlank(v.getStoreName()));
    }
}
