package com.elitesland.cbpl.sns.inbox.pipeline;

import com.elitesland.cbpl.sns.inbox.domain.InboxPayload;
import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.sns.inbox.vo.param.InboxPageParamVO;
import com.elitesland.cbpl.tool.db.PagingVO;
import com.elitesland.cbpl.unicom.adapter.SpecifyAdapter;
import com.elitesland.cbpl.unicom.annotation.Unicom;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

/**
 * 站内信
 *
 * @author eric.hao
 * @since 2024/12/19
 */
@Unicom(adapter = SpecifyAdapter.class)
public interface InboxPipeline {

    /**
     * 保存新消息
     *
     * @param payload 信件包裹
     */
    void save(InboxPayload payload);

    /**
     * 未读消息统计
     *
     * @param reader 收件人
     * @param types  消息类型
     * @return 每种类型的未读计数
     */
    Map<InboxType, Long> countUnread(String reader, Stream<InboxType> types);

    /**
     * 分页查询
     *
     * @param params 查询参数
     * @return 查询结果
     */
    PagingVO<? extends InboxPayload> find(InboxPageParamVO params);

    /**
     * 查询明细
     *
     * @param type      消息类型
     * @param messageId 消息ID
     * @param reader    收信人
     * @return 消息
     */
    Optional<? extends InboxPayload> read(InboxType type, String messageId, String reader);

    /**
     * 全部已读
     *
     * @param type   消息类型
     * @param reader 收信人
     */
    void readAllMessages(InboxType type, String reader);

    /**
     * 消息类型下拉
     */
    List<Map<String, String>> getMsgType();
}
