package com.elitesland.cbpl.sns.inbox.pipeline.mongo.query;

import com.elitesland.cbpl.sns.inbox.domain.InboxType;
import com.elitesland.cbpl.tool.mongo.repository.MongoQuery;
import lombok.Builder;
import lombok.ToString;
import lombok.extern.slf4j.Slf4j;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;

import static org.springframework.data.mongodb.core.query.Criteria.where;

/**
 * @author eric.hao
 * @since 2024/12/23
 */
@Slf4j
@Builder
@ToString
public class InboxUnreadQuery extends MongoQuery {

    @Override
    public String getStoreName() {
        return type.getStoreName();
    }

    /**
     * 消息类型
     */
    private InboxType type;

    /**
     * 收信人ID
     */
    private String reader;

    private void addRecipientsCriteria(Query query) {
        query.addCriteria(new Criteria().orOperator(
                where("tos").size(0),
                where("tos").is(reader)
        ));
    }

    private void addReadTimesCriteria(Query query) {
        query.addCriteria(where("read." + reader).exists(false));
    }

    @Override
    protected Query buildQuery() {
        Query query = new Query();
        addRecipientsCriteria(query);
        addReadTimesCriteria(query);
        logger.debug("[SNS-INBOX] query: {}", query);
        return query;
    }

}
